/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.PushContext;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.data.DataField;
import com.elixirtech.erd.reportdesigner.data.InfoBuilder;
import com.elixirtech.erd.reportdesigner.data.ValuesDialog;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.wizard.ParameterUI;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InspectFieldAction
extends ERDAction {
    private final DataField m_Field;

    public InspectFieldAction(DataField dataField) {
        super("InspectField.InspectValues");
        this.m_Field = dataField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        ValuesDialog valuesDialog = new ValuesDialog(elixirFrame.getFrame());
        DataSource dataSource = this.m_Field.getDataSource();
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
            DataSchema dataSchema = iDataSource.getSchema();
            int n = dataSchema.getColumnIndex(this.m_Field.getName());
            if (n >= 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (InspectFieldAction.getParams(iDataSource.getParameters(), hashMap)) {
                    DefaultPushContext defaultPushContext = new DefaultPushContext();
                    defaultPushContext.setParameters(hashMap);
                    InfoBuilder infoBuilder = new InfoBuilder(iDataSource, n);
                    iDataSource.pushTo((PushContext)defaultPushContext, (DataListener)infoBuilder);
                    valuesDialog.setColumnInfo(infoBuilder);
                    valuesDialog.setLocationRelativeTo(elixirFrame.getFrame());
                    elixirFrame.showModal(valuesDialog);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Throwable throwable) {
            ElixirJ.error(I18N.ERD.getString("InspectField.Exception"), throwable);
        }
    }

    private static boolean getParams(List<Parameter> list, Map<String, String> map) {
        if (ParameterUtil.getParamCount(list) > 0) {
            ParameterUI parameterUI = new ParameterUI(list, null);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(parameterUI);
            if (!parameterUI.isFinished()) {
                return false;
            }
            parameterUI.populateProperties(map);
        }
        return true;
    }
}

