/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.erd.reportdesigner.data.Pair;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ParameterModel
extends ElxTableModel {
    private static String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Value"};
    private List<Pair> m_Items = new ArrayList<Pair>();
    private Properties m_Properties;

    public ParameterModel(IDataSource iDataSource, Properties properties) {
        super(I18N.ERD, COLUMNS);
        this.m_Properties = properties;
        if (iDataSource != null) {
            List list = iDataSource.getParameters();
            for (Parameter parameter : list) {
                String string = parameter.getName();
                if (string.startsWith("elixir.report.ds")) continue;
                Pair pair = new Pair(parameter);
                String string2 = this.m_Properties.getProperty(string);
                pair.value = StringUtil.notEmpty(string2) ? string2 : parameter.getDollarSubstitution();
                this.m_Items.add(pair);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.m_Items.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Pair pair = this.m_Items.get(n);
        if (n2 == 0) {
            return pair.getName();
        }
        return pair.getValue();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            Pair pair = this.m_Items.get(n);
            String string = (String)object;
            if (StringUtil.isEmpty(string)) {
                string = null;
            }
            pair.value = string;
        }
    }

    public void addPair(String string, String string2) {
        Parameter parameter = new Parameter();
        parameter.setName(string);
        Pair pair = new Pair(parameter);
        pair.value = string2;
        this.m_Items.add(pair);
    }

    public void addParameter(Parameter[] parameterArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Pair pair : this.m_Items) {
            if (pair.value == null) continue;
            hashMap.put(pair.getName(), pair.value);
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            if (parameterArray[i].getName().startsWith("elixir.report.ds")) continue;
            Pair pair = new Pair(parameterArray[i]);
            pair.value = (String)hashMap.get(pair.getName());
            if (StringUtil.isEmpty(pair.value)) {
                pair.value = "${" + pair.getName() + "}";
            }
            this.m_Items.add(pair);
        }
        Collections.sort(this.m_Items);
    }

    public void setParameters(Parameter[] parameterArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Pair pair : this.m_Items) {
            if (pair.value == null) continue;
            hashMap.put(pair.getName(), pair.value);
        }
        this.m_Items.clear();
        for (int i = 0; i < parameterArray.length; ++i) {
            if (parameterArray[i].getName().startsWith("elixir.report.ds")) continue;
            Pair pair = new Pair(parameterArray[i]);
            pair.value = (String)hashMap.get(pair.getName());
            this.m_Items.add(pair);
        }
        Collections.sort(this.m_Items);
    }

    public void setDefaultAt(int n) {
        Pair pair = this.m_Items.get(n);
        pair.value = pair.parameter.getDollarSubstitution();
    }

    public void performFinish() {
        this.m_Properties.clear();
        for (Pair pair : this.m_Items) {
            if (pair.value == null) continue;
            this.m_Properties.setProperty(pair.getName(), pair.value);
        }
    }

    public Properties getProperties() {
        return this.m_Properties;
    }

    public Parameter getParameter(int n) {
        return this.m_Items.get((int)n).parameter;
    }
}

