/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.data;

import com.elixirtech.data2.DataType;
import com.elixirtech.erd.reportdesigner.data.ColumnDataModel;
import com.elixirtech.erd.reportdesigner.data.ColumnInfo;
import com.elixirtech.erd.reportdesigner.data.ColumnInfoModel;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.table.ElxTable;
import com.elixirtech.util.Pair;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ValuesPanel
extends JPanel {
    private ColumnInfoModel m_InfoModel;
    private ElxTable m_InfoTable;
    private ColumnDataModel m_DataModel;
    private ElxTable m_DataTable;
    private JFreeChart m_Chart;
    private JSplitPane m_SplitPane;
    private JScrollPane m_Top;
    static final NumberFormat FLOAT = NumberFormat.getNumberInstance();
    static final NumberFormat PERCENT = NumberFormat.getPercentInstance();

    public ValuesPanel() {
        this.setLayout(new GridLayout(1, 2));
        this.m_InfoModel = new ColumnInfoModel();
        this.m_InfoTable = new ElxTable();
        this.m_InfoTable.setModel(this.m_InfoModel);
        this.m_DataModel = new ColumnDataModel();
        this.m_DataTable = new ElxTable();
        this.m_DataTable.setModel(this.m_DataModel);
        this.m_Top = new JScrollPane(this.m_InfoTable);
        JScrollPane jScrollPane = new JScrollPane(this.m_DataTable);
        this.m_SplitPane = new JSplitPane(0, this.m_Top, jScrollPane);
        this.m_SplitPane.setDividerLocation(0.5);
        this.add(this.m_SplitPane);
        PiePlot piePlot = new PiePlot();
        this.m_Chart = new JFreeChart(I18N.ERD.getString("ValuesPanel.LOADING"), (Plot)piePlot);
        this.m_Chart.removeLegend();
        this.add((Component)new ChartPanel(this.m_Chart));
    }

    public void load(ColumnInfo columnInfo) {
        Map<String, Long> map = columnInfo.getValues();
        this.m_InfoModel.addInfo("ColumnInfoModel.ROW_COUNT", columnInfo.getRecordCount());
        this.m_InfoModel.addInfo("ColumnInfoModel.NULL_COUNT", columnInfo.getNullCount());
        this.m_InfoModel.addInfo("ColumnInfoModel.UNIQUE_VALUES", map.size());
        this.m_InfoModel.addInfo("ColumnInfoModel.PERCENT_NULL", ValuesPanel.percent(columnInfo.getNullCount(), columnInfo.getRecordCount()));
        this.m_InfoModel.addInfo("ColumnInfoModel.PERCENT_UNIQUE", ValuesPanel.percent(map.size(), columnInfo.getRecordCount()));
        this.m_InfoModel.addInfo("ColumnInfoModel.MIN_VALUE", columnInfo.getMin());
        this.m_InfoModel.addInfo("ColumnInfoModel.MAX_VALUE", columnInfo.getMax());
        if (DataType.STRING.equals(columnInfo.getType())) {
            this.m_InfoModel.addInfo("ColumnInfoModel.MIN_LENGTH", columnInfo.getMinLength());
            this.m_InfoModel.addInfo("ColumnInfoModel.MAX_LENGTH", columnInfo.getMaxLength());
        } else if (columnInfo.getType().isNumeric()) {
            this.m_InfoModel.addInfo("ColumnInfoModel.AVERAGE_VALUE", FLOAT.format(columnInfo.getAverage()));
        }
        ArrayList<Pair<Long, String>> arrayList = new ArrayList<Pair<Long, String>>();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            arrayList.add(new Pair<Long, String>(entry.getValue(), entry.getKey()));
        }
        Collections.sort(arrayList, new DescendingPairComparator());
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n = 0;
        for (Pair object2 : arrayList) {
            if (n < 10) {
                defaultPieDataset.setValue((Comparable)object2.second, (Number)object2.first);
                ++n;
            }
            this.m_DataModel.addData(object2);
        }
        PiePlot piePlot = (PiePlot)this.m_Chart.getPlot();
        piePlot.setNoDataMessage(I18N.ERD.getString("ValuesPanel.NO_DATA"));
        piePlot.setDataset((PieDataset)defaultPieDataset);
        Dimension dimension = this.m_InfoTable.getPreferredSize();
        dimension.height += 20;
        this.m_SplitPane.setDividerLocation(dimension.height);
        this.m_Chart.setTitle(I18N.ERD.getString("ValuesPanel.TOP_TEN"));
    }

    public List<String> getValues() {
        return this.m_DataModel.getValues();
    }

    static String percent(long l, long l2) {
        double d = (double)l / (double)l2;
        return PERCENT.format(d);
    }

    static {
        FLOAT.setMaximumFractionDigits(2);
    }

    private static class DescendingPairComparator
    implements Comparator<Pair<Long, String>> {
        private DescendingPairComparator() {
        }

        @Override
        public int compare(Pair<Long, String> pair, Pair<Long, String> pair2) {
            return ((Long)pair2.first).compareTo((Long)pair.first);
        }
    }
}

