/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.dnd;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.chunk.ChunkManager;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.dnd.DNDTrigger;
import com.elixirtech.erd.reportdesigner.shape.UiElementShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.Chart;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.property.IApplyRepainter;
import com.elixirtech.ui.property.PropertyDialog;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.util.WizardUtil;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChartDNDTrigger
implements DNDTrigger {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartDNDTrigger.class);
    private DataFlavor m_DataFlavor;

    public ChartDNDTrigger(DataFlavor dataFlavor) {
        this.m_DataFlavor = dataFlavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.m_DataFlavor;
    }

    @Override
    public void dropSource(ChunkPanel chunkPanel, Object object, Point point) {
        Repository repository = (Repository)Elixir.get(Repository.class);
        FileObject fileObject = repository.getFileJ((String)object);
        String string = fileObject.getName();
        if (string.endsWith(".cml")) {
            string = string.substring(0, string.length() - 4);
        }
        String string2 = fileObject.getPath().toString();
        m_Log.debug((Object)("File name: " + string + ", path:" + string2));
        ChunkManager chunkManager = chunkPanel.getChunkManager();
        BasicRawElementHolder basicRawElementHolder = chunkManager.getHolderAt(point);
        Chart chart = new Chart();
        chart.setParent((IRawElementHolder)basicRawElementHolder);
        chart.setChartURL(string2);
        Chunk chunk = chunkPanel.getChunk();
        RawReport rawReport = (RawReport)chunk.getResourceProvider();
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        PropertyDialog propertyDialog = new PropertyDialog(elixirFrame.getFrame(), false, "DataSource", (IApplyRepainter)((Object)elixirFrame));
        propertyDialog.addTab(new DataSourceTab(rawReport, chart, chunkManager, point));
        propertyDialog.setLocationRelativeTo(chunkPanel);
        propertyDialog.pack();
        elixirFrame.showModal(propertyDialog);
        propertyDialog.isFinished();
    }

    public UiModelElementShape createShapeFor(Chart chart) {
        UiElementShape uiElementShape = new UiElementShape();
        ((UiModelElementShape)uiElementShape).setModel((RawModelElement)chart);
        return uiElementShape;
    }

    class DataSourceTab
    extends TabComponent {
        private Point m_Location;
        private ChunkManager m_ChunkManager;
        private Chart m_Chart;
        private JButton m_TriggerAddDSWizard;
        private JComboBox m_DataSources;
        private RawReport m_RawReport;

        public DataSourceTab(RawReport rawReport, Chart chart, ChunkManager chunkManager, Point point) {
            this.m_Chart = chart;
            this.m_RawReport = rawReport;
            this.m_Location = point;
            this.m_ChunkManager = chunkManager;
            this.buildUI();
        }

        private void buildUI() {
            this.setLayout(new FlowLayout(1));
            this.m_TriggerAddDSWizard = new JButton("...");
            this.m_TriggerAddDSWizard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceTab.this.addDataSource();
                }
            });
            this.m_DataSources = new JComboBox<String>(this.getDataSources());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("West", new JLabel("Set DataSource:"));
            jPanel.add("Center", this.m_DataSources);
            jPanel.add("East", this.m_TriggerAddDSWizard);
            this.add("Center", jPanel);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            SwingUtil.setEnabled(this, bl);
        }

        @Override
        public String getName() {
            return "Select DataSource";
        }

        @Override
        public String getMessage() {
            return "Please select Datasource.";
        }

        @Override
        public void performFinish() {
            String string = "Default";
            Object object = this.m_DataSources.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            this.m_Chart.setDataSource(string);
            UiModelElementShape uiModelElementShape = ChartDNDTrigger.this.createShapeFor(this.m_Chart);
            uiModelElementShape.setRect(new Rectangle(this.m_Location.x, this.m_Location.y, 1000, 2000));
            BasicRawElementHolder basicRawElementHolder = this.m_ChunkManager.getHolderAt(this.m_Location);
            this.m_ChunkManager.add(basicRawElementHolder, (RawModelElement)this.m_Chart, false);
        }

        protected void addDataSource() {
            WizardUtil.addDS(this.m_RawReport, this.m_DataSources);
        }

        protected String[] getDataSources() {
            return WizardUtil.getDataSourceNames(this.m_RawReport);
        }
    }
}

