/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.dnd;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.dnd.DNDTrigger;
import com.elixirtech.ui.SwingUtil;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.HashMap;

public class DNDProvider {
    private static ArrayList<DataFlavor> FLAVOURS = new ArrayList();
    private static HashMap<DataFlavor, DNDTrigger> m_DropTriggers = new HashMap();
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DNDProvider.class);
    private ChunkPanel m_Panel;

    public static void registerDragAndDrop(DNDTrigger dNDTrigger) {
        FLAVOURS.add(dNDTrigger.getFlavor());
        m_DropTriggers.put(dNDTrigger.getFlavor(), dNDTrigger);
    }

    public DNDProvider(ChunkPanel chunkPanel) {
        this.m_Panel = chunkPanel;
        SwingUtil.setupDropTarget(this.m_Panel, new DTL());
    }

    public boolean isDataFlavorSupported(DataFlavor[] dataFlavorArray) {
        return FLAVOURS.contains(dataFlavorArray[0]);
    }

    public void dropSource(DataFlavor[] dataFlavorArray, Object object, Point point) {
        if (this.m_Panel.isReadOnly()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        assert (dataFlavorArray.length > 0);
        DNDTrigger dNDTrigger = m_DropTriggers.get(dataFlavorArray[0]);
        if (dNDTrigger != null) {
            point = this.m_Panel.convertPointFromPanelToBody(point);
            point.x *= 20;
            point.y *= 20;
            this.m_Panel.ensureCurrent();
            dNDTrigger.dropSource(this.m_Panel, object, point);
        }
    }

    private class DTL
    implements DropTargetListener {
        private DTL() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (DNDProvider.this.isDataFlavorSupported(dropTargetDragEvent.getCurrentDataFlavors())) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (DNDProvider.this.isDataFlavorSupported(dropTargetDragEvent.getCurrentDataFlavors())) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (DNDProvider.this.isDataFlavorSupported(transferable.getTransferDataFlavors())) {
                try {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Object object = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                    DNDProvider.this.dropSource(transferable.getTransferDataFlavors(), object, dropTargetDropEvent.getLocation());
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (Exception exception) {
                    dropTargetDropEvent.dropComplete(false);
                    m_Log.error((Object)("Drop target error," + exception.toString()), (Throwable)exception);
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }
    }
}

