/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.dnd;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.erd.reportdesigner.chunk.ChunkManager;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.data.DataField;
import com.elixirtech.erd.reportdesigner.data.DataFieldSet;
import com.elixirtech.erd.reportdesigner.dnd.DNDTrigger;
import com.elixirtech.erd.reportdesigner.dnd.FieldLayoutWizard;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Section;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;

public class DataFieldDNDTrigger
implements DNDTrigger {
    private DataFlavor m_DataFlavor;
    private static UiElementBeanFactory m_Factory = new UiElementBeanFactory(Field.class);

    public DataFieldDNDTrigger(DataFlavor dataFlavor) {
        this.m_DataFlavor = dataFlavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.m_DataFlavor;
    }

    @Override
    public void dropSource(ChunkPanel chunkPanel, Object object, Point point) {
        ChunkManager chunkManager = chunkPanel.getChunkManager();
        BasicRawElementHolder basicRawElementHolder = chunkManager.getHolderAt(point);
        if (basicRawElementHolder != null) {
            if (object instanceof DataField) {
                this.createShape(chunkPanel, basicRawElementHolder, (DataField)object, point);
            } else {
                DataFieldSet dataFieldSet = (DataFieldSet)object;
                DataField[] dataFieldArray = dataFieldSet.getDataFields();
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                FieldLayoutWizard fieldLayoutWizard = new FieldLayoutWizard(chunkPanel, dataFieldArray);
                elixirFrame.showWizard(fieldLayoutWizard);
                if (fieldLayoutWizard.isFinished()) {
                    fieldLayoutWizard.layoutFields(dataFieldArray, point);
                }
            }
        }
    }

    private AbstractShape createShape(ChunkPanel chunkPanel, BasicRawElementHolder basicRawElementHolder, DataField dataField, Point point) {
        RawModelElement rawModelElement = m_Factory.createBean(chunkPanel, (IRawElementHolder)basicRawElementHolder, null);
        if (rawModelElement != null) {
            Section section = chunkPanel.getChunk().getSection();
            String string = section.getDataSource();
            String string2 = dataField.getDataSource().getName();
            ControlSource controlSource = new ControlSource();
            controlSource.setType("Field");
            if (!string2.equals(string)) {
                controlSource.setDataSource(string2);
            }
            controlSource.setField(dataField.getName());
            controlSource.setText((String)(string2.equals(string) ? dataField.getName() : string2 + ":" + dataField.getName()));
            ((Field)rawModelElement).setControlSource(controlSource);
            UiModelElementShape uiModelElementShape = UiFactory.current().buildShape(rawModelElement);
            if (uiModelElementShape != null) {
                Rectangle rectangle = new Rectangle(point.x, point.y, 2000, 400);
                ((AbstractShape)uiModelElementShape).setRect(rectangle);
                ChunkManager chunkManager = chunkPanel.getChunkManager();
                chunkManager.add(basicRawElementHolder, rawModelElement, false);
                rawModelElement.loaded();
                return uiModelElementShape;
            }
        }
        return null;
    }
}

