/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.dnd;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.erd.reportdesigner.chunk.ChunkManager;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.data.DataField;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.HBoxShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.shape.VBoxShape;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.Box;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Detail;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableFooter;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.report2.raw.model.VBox;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.UnitField;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FieldLayoutWizard
extends Wizard {
    private static final int HEIGHT = 400;
    private static final int WIDTH = 1200;
    ChunkPanel m_ChunkPanel;
    DataField[] m_Fields;
    RawReport m_Report;
    String[] m_Styles;
    private FieldLayoutPage m_Page;
    private static UiElementBeanFactory m_Factory = new UiElementBeanFactory(Field.class);

    public FieldLayoutWizard(ChunkPanel chunkPanel, DataField[] dataFieldArray) {
        super(I18N.ERD.getString("FieldLayoutWizard.title"));
        this.m_ChunkPanel = chunkPanel;
        this.m_Fields = dataFieldArray;
        this.m_Report = chunkPanel.getReport();
        this.m_Styles = this.m_Report.getStyleNames();
        this.m_Page = new FieldLayoutPage();
        this.m_Page.setWizard(this);
        this.m_Pages.add(this.m_Page);
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    public void layoutFields(DataField[] dataFieldArray, Point point) {
        this.m_Page.layoutFields(dataFieldArray, point);
    }

    BasicRawElementHolder getLabelParent(Box box, boolean bl) {
        if (box != null) {
            Cell cell = new Cell();
            box.addCell(cell);
            this.createShape((BasicRawElementHolder)box, (RawModelElement)cell, null);
            return cell;
        }
        if (bl) {
            return this.getHeader();
        }
        return this.m_ChunkPanel.getChunk();
    }

    BasicRawElementHolder getFieldParent(Box box) {
        if (box != null) {
            Cell cell = new Cell();
            box.addCell(cell);
            this.createShape((BasicRawElementHolder)box, (RawModelElement)cell, null);
            return cell;
        }
        return this.m_ChunkPanel.getChunk();
    }

    Chunk getHeader() {
        Section section;
        int n;
        Chunk chunk = this.m_ChunkPanel.getChunk();
        if (chunk instanceof Detail && (n = (section = chunk.getSection()).getGroupCount()) > 0) {
            Group group = section.getGroup(n - 1);
            return group.getGroupHeader();
        }
        return null;
    }

    Field createField(BasicRawElementHolder basicRawElementHolder, DataField dataField, String string, boolean bl) {
        boolean bl2;
        Field field = (Field)m_Factory.createBean(this.m_ChunkPanel, (IRawElementHolder)basicRawElementHolder, string);
        Section section = this.m_ChunkPanel.getChunk().getSection();
        String string2 = section.getDataSource();
        String string3 = dataField.getDataSource().getName();
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        boolean bl3 = bl2 = string3.equals(string2) && !bl;
        if (!bl2) {
            controlSource.setDataSource(string3);
        }
        controlSource.setField(dataField.getName());
        controlSource.setText((String)(bl2 ? dataField.getName() : string3 + ":" + dataField.getName()));
        field.setControlSource(controlSource);
        if (dataField.getType().isNumeric()) {
            field.setTextAlign("Right");
        }
        return field;
    }

    Field createOperation(BasicRawElementHolder basicRawElementHolder, DataField dataField, String string, boolean bl) {
        Field field = (Field)m_Factory.createBean(this.m_ChunkPanel, (IRawElementHolder)basicRawElementHolder, string);
        if (dataField.getType().isNumeric()) {
            boolean bl2;
            Section section = this.m_ChunkPanel.getChunk().getSection();
            String string2 = section.getDataSource();
            String string3 = dataField.getDataSource().getName();
            ControlSource controlSource = new ControlSource();
            controlSource.setType("Operation");
            boolean bl3 = bl2 = string3.equals(string2) && !bl;
            if (!bl2) {
                controlSource.setDataSource(string3);
            }
            controlSource.setField(dataField.getName());
            controlSource.setOperation("Sum");
            controlSource.setText((String)(bl2 ? dataField.getName() : string3 + ":" + dataField.getName()));
            field.setControlSource(controlSource);
            field.setTextAlign("Right");
        } else {
            ControlSource controlSource = new ControlSource();
            controlSource.setType("Literal");
            field.setControlSource(controlSource);
        }
        return field;
    }

    Field createLabel(BasicRawElementHolder basicRawElementHolder, DataField dataField, String string, boolean bl) {
        Field field = (Field)m_Factory.createBean(this.m_ChunkPanel, (IRawElementHolder)basicRawElementHolder, string);
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Literal");
        controlSource.setText(dataField.getName());
        field.setControlSource(controlSource);
        if (bl) {
            field.setTextAlign("Center");
        }
        return field;
    }

    AbstractShape createShape(BasicRawElementHolder basicRawElementHolder, RawModelElement rawModelElement, Rectangle rectangle) {
        UiModelElementShape uiModelElementShape = UiFactory.current().buildShape(rawModelElement);
        if (uiModelElementShape != null) {
            if (rectangle != null) {
                ((AbstractShape)uiModelElementShape).setRect(this.constrainRect(basicRawElementHolder, rectangle));
            }
            ChunkManager chunkManager = this.m_ChunkPanel.getChunkManager();
            chunkManager.add(basicRawElementHolder, rawModelElement, false);
            rawModelElement.loaded();
        }
        return uiModelElementShape;
    }

    Rectangle constrainRect(BasicRawElementHolder basicRawElementHolder, Rectangle rectangle) {
        if (basicRawElementHolder.getLeft() > rectangle.x) {
            rectangle.x = basicRawElementHolder.getLeft();
        }
        if (basicRawElementHolder.getTop() > rectangle.y) {
            rectangle.y = basicRawElementHolder.getTop();
        }
        int n = basicRawElementHolder.getLeft() + this.m_ChunkPanel.getChunkWidth();
        int n2 = basicRawElementHolder.getTop() + basicRawElementHolder.getHeight();
        if (n < rectangle.x + rectangle.width) {
            rectangle.x = n - rectangle.width;
        }
        if (n2 < rectangle.y + rectangle.height) {
            rectangle.y = n2 - rectangle.height;
        }
        return rectangle;
    }

    private class FieldLayoutPage
    extends WizardPage {
        private JTabbedPane m_Tabs;
        private HorizontalPanel m_HPanel;
        private VerticalPanel m_VPanel;
        private TablePanel m_TPanel;

        public FieldLayoutPage() {
            super("Layout", null);
            this.m_HPanel = new HorizontalPanel();
            this.m_VPanel = new VerticalPanel();
            this.m_TPanel = new TablePanel();
            this.setTitle(I18N.ERD.getString("FieldLayoutPage.name"));
            this.setMessage(I18N.ERD.getString("FieldLayoutPage.message"));
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_Tabs = new JTabbedPane();
            this.m_Component.setLayout(new BorderLayout());
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_Tabs.addTab(I18N.ERD.getString("FieldLayoutPage.horizontal.title"), this.m_HPanel.getComponent());
            this.m_Tabs.addTab(I18N.ERD.getString("FieldLayoutPage.vertical.title"), this.m_VPanel.getComponent());
            this.m_Tabs.addTab(I18N.ERD.getString("FieldLayoutPage.table.title"), this.m_TPanel.getComponent());
            this.m_Component.add(this.m_Tabs);
            I18N.ERD_MAP.injectComponents("FieldLayoutPage.", this.m_Component);
        }

        public void layoutFields(DataField[] dataFieldArray, Point point) {
            int n = this.m_Tabs.getSelectedIndex();
            LayoutPanel layoutPanel = null;
            if (n == 0) {
                layoutPanel = this.m_HPanel;
            } else if (n == 1) {
                layoutPanel = this.m_VPanel;
            }
            if (n == 2) {
                layoutPanel = this.m_TPanel;
            }
            if (layoutPanel != null) {
                layoutPanel.layoutFields(dataFieldArray, point);
            }
        }
    }

    private final class TablePanel
    extends LayoutPanel {
        private JCheckBox m_Header;
        private JCheckBox m_Footer;
        private JComboBox m_Cache;
        private JComboBox m_TableStyle;
        private JComboBox m_HeaderStyle;
        private JComboBox m_FieldStyle;
        private JComboBox m_FooterStyle;

        public TablePanel() {
            this.m_Header = SwingFactory.newCheckBox("show-header");
            this.m_Footer = SwingFactory.newCheckBox("show-footer");
            this.m_Cache = SwingFactory.newComboBox("cache", this.getCacheChoices());
            this.m_TableStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_HeaderStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_FieldStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_FooterStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_Component.add(this.m_Header);
            this.m_Component.add(this.m_Footer);
            this.m_Layout.addLabel((JComponent)this.m_Component, "cache", SwingFactory.newLabel("cache-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "tstyle", SwingFactory.newLabel("tstyle-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "hstyle", SwingFactory.newLabel("hstyle-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "fstyle", SwingFactory.newLabel("fstyle-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "f2style", SwingFactory.newLabel("f2style-label"));
            this.m_Component.add("cache", this.m_Cache);
            this.m_Component.add("tstyle", this.m_TableStyle);
            this.m_Component.add("hstyle", this.m_HeaderStyle);
            this.m_Component.add("fstyle", this.m_FieldStyle);
            this.m_Component.add("f2style", this.m_FooterStyle);
            this.m_Layout.stickTop("show-header");
            this.m_Layout.stickLeft("show-header");
            this.m_Layout.alignBelow("show-footer", "show-header");
            this.m_Layout.putBelow("cache", "show-footer", 10);
            this.m_Layout.putRight("cache", "cache-label,tstyle-label,hstyle-label,fstyle-label,f2style-label", 10);
            this.m_Layout.alignBelow("tstyle", "cache", 10);
            this.m_Layout.alignBelow("hstyle", "tstyle");
            this.m_Layout.alignBelow("fstyle", "hstyle");
            this.m_Layout.alignBelow("f2style", "fstyle");
            this.m_Header.addItemListener(this.m_Watcher);
            this.m_Footer.addItemListener(this.m_Watcher);
            this.update();
        }

        @Override
        public void layoutFields(DataField[] dataFieldArray, Point point) {
            Field field;
            Cell cell;
            int n;
            Table table = new Table();
            table.setStyleName((String)this.m_TableStyle.getSelectedItem());
            table.setCache((String)this.m_Cache.getSelectedItem());
            int n2 = dataFieldArray.length * 1200;
            int n3 = 400;
            Object object = new TableBody();
            object.setWidth(n2);
            object.setHeight(400);
            table.setBody(object);
            HBox hBox = new HBox();
            hBox.setFill(true);
            object.addRawElement((RawModelElement)hBox);
            String string = (String)this.m_FieldStyle.getSelectedItem();
            if (StringUtil.isEmpty(string)) {
                string = null;
            }
            for (n = 0; n < dataFieldArray.length; ++n) {
                cell = this.createCell(hBox);
                field = FieldLayoutWizard.this.createField((BasicRawElementHolder)cell, dataFieldArray[n], string, true);
                cell.addRawElement((RawModelElement)field);
            }
            if (this.m_Header.isSelected()) {
                object = new TableHeader();
                object.setWidth(n2);
                object.setHeight(400);
                table.setHeader((TableHeader)object);
                n3 += 400;
                hBox = new HBox();
                hBox.setFill(true);
                object.addRawElement((RawModelElement)hBox);
                string = (String)this.m_HeaderStyle.getSelectedItem();
                if (StringUtil.isEmpty(string)) {
                    string = null;
                }
                for (n = 0; n < dataFieldArray.length; ++n) {
                    cell = this.createCell(hBox);
                    field = FieldLayoutWizard.this.createLabel((BasicRawElementHolder)cell, dataFieldArray[n], string, true);
                    cell.addRawElement((RawModelElement)field);
                }
            }
            if (this.m_Footer.isSelected()) {
                object = new TableFooter();
                object.setWidth(n2);
                object.setHeight(400);
                table.setFooter((TableFooter)object);
                n3 += 400;
                hBox = new HBox();
                hBox.setFill(true);
                object.addRawElement((RawModelElement)hBox);
                string = (String)this.m_FooterStyle.getSelectedItem();
                if (StringUtil.isEmpty(string)) {
                    string = null;
                }
                for (n = 0; n < dataFieldArray.length; ++n) {
                    cell = this.createCell(hBox);
                    field = FieldLayoutWizard.this.createOperation((BasicRawElementHolder)cell, dataFieldArray[n], string, true);
                    if (field == null) continue;
                    cell.addRawElement((RawModelElement)field);
                }
            }
            object = new Rectangle(point.x, point.y, n2, n3);
            FieldLayoutWizard.this.createShape((BasicRawElementHolder)FieldLayoutWizard.this.m_ChunkPanel.getChunk(), (RawModelElement)table, (Rectangle)object);
            FieldLayoutWizard.this.m_ChunkPanel.getSelectionManager().setSelection((RawModelElement)table);
        }

        @Override
        public void update() {
            this.m_HeaderStyle.setEnabled(this.m_Header.isSelected());
            this.m_FooterStyle.setEnabled(this.m_Footer.isSelected());
        }

        String[] getCacheChoices() {
            TreeSet<String> treeSet = new TreeSet<String>();
            String string = FieldLayoutWizard.this.m_ChunkPanel.getChunk().getSection().getDataSource();
            if (StringUtil.notEmpty(string)) {
                treeSet.add(string);
            }
            for (int i = 0; i < FieldLayoutWizard.this.m_Fields.length; ++i) {
                FieldLayoutWizard.this.m_Fields[i].getDataSource().getName();
            }
            String[] stringArray = new String[treeSet.size()];
            treeSet.toArray(stringArray);
            return stringArray;
        }

        Cell createCell(HBox hBox) {
            Cell cell = new Cell();
            hBox.addCell(cell);
            return cell;
        }
    }

    private final class VerticalPanel
    extends LayoutPanel {
        private JCheckBox m_Labels;
        private JCheckBox m_VBox;
        private UnitField m_Spacing;
        private JComboBox m_LabelStyle;
        private JComboBox m_FieldStyle;

        public VerticalPanel() {
            this.m_Labels = SwingFactory.newCheckBox("labels");
            this.m_VBox = SwingFactory.newCheckBox("vbox");
            this.m_Spacing = new UnitField();
            this.m_Spacing.setColumns(5);
            this.m_LabelStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_FieldStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_Component.add(this.m_Labels);
            this.m_Component.add(this.m_VBox);
            this.m_Layout.addLabel((JComponent)this.m_Component, "spacing", SwingFactory.newLabel("spacing-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "lstyle", SwingFactory.newLabel("lstyle-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "fstyle", SwingFactory.newLabel("fstyle-label"));
            this.m_Component.add("spacing", this.m_Spacing);
            this.m_Component.add("lstyle", this.m_LabelStyle);
            this.m_Component.add("fstyle", this.m_FieldStyle);
            this.m_Layout.stickTop("labels");
            this.m_Layout.stickLeft("labels");
            this.m_Layout.alignBelow("vbox", "labels");
            this.m_Layout.putBelow("spacing", "vbox", 10);
            this.m_Layout.putRight("spacing", "spacing-label,lstyle-label,fstyle-label", 10);
            this.m_Layout.alignBelow("lstyle", "spacing", 10);
            this.m_Layout.alignBelow("fstyle", "lstyle");
            this.m_Labels.addItemListener(this.m_Watcher);
            this.update();
        }

        @Override
        public void layoutFields(DataField[] dataFieldArray, Point point) {
            Rectangle rectangle;
            String string;
            HBox[] hBoxArray = null;
            VBox vBox = null;
            String string2 = (String)this.m_LabelStyle.getSelectedItem();
            if (StringUtil.isEmpty(string2)) {
                string2 = null;
            }
            if (StringUtil.isEmpty(string = (String)this.m_FieldStyle.getSelectedItem())) {
                string = null;
            }
            if (this.m_VBox.isSelected()) {
                Chunk chunk = FieldLayoutWizard.this.m_ChunkPanel.getChunk();
                vBox = new VBox();
                vBox.setName("Fields");
                int n = point.x;
                rectangle = new Rectangle(n, point.y, 1200, dataFieldArray.length * 400);
                FieldLayoutWizard.this.createShape((BasicRawElementHolder)chunk, (RawModelElement)vBox, rectangle);
                hBoxArray = new HBox[dataFieldArray.length];
                for (int i = 0; i < hBoxArray.length; ++i) {
                    hBoxArray[i] = new HBox();
                    Rectangle rectangle2 = new Rectangle(n, point.y + i * 400, 1200, 400);
                    BasicRawElementHolder basicRawElementHolder = FieldLayoutWizard.this.getFieldParent((Box)vBox);
                    FieldLayoutWizard.this.createShape(basicRawElementHolder, (RawModelElement)hBoxArray[i], rectangle2);
                }
            }
            for (int i = 0; i < dataFieldArray.length; ++i) {
                Object object = hBoxArray != null && this.m_Labels.isSelected() ? FieldLayoutWizard.this.getLabelParent((Box)hBoxArray[i], false) : FieldLayoutWizard.this.m_ChunkPanel.getChunk();
                if (this.m_Labels.isSelected()) {
                    rectangle = FieldLayoutWizard.this.createLabel((BasicRawElementHolder)object, dataFieldArray[i], string2, false);
                    Rectangle rectangle3 = this.getLabelRect(i, point);
                    FieldLayoutWizard.this.createShape((BasicRawElementHolder)object, (RawModelElement)rectangle, rectangle3);
                }
                if (hBoxArray != null) {
                    object = FieldLayoutWizard.this.getLabelParent((Box)hBoxArray[i], false);
                }
                rectangle = FieldLayoutWizard.this.createField((BasicRawElementHolder)object, dataFieldArray[i], string, false);
                Rectangle rectangle4 = this.getFieldRect(i, point);
                FieldLayoutWizard.this.createShape((BasicRawElementHolder)object, (RawModelElement)rectangle, rectangle4);
            }
            if (vBox != null) {
                ((VBoxShape)vBox.getShape()).layoutCells();
                FieldLayoutWizard.this.m_ChunkPanel.getSelectionManager().setSelection((RawModelElement)vBox);
            }
        }

        @Override
        public void update() {
            this.m_LabelStyle.setEnabled(this.m_Labels.isSelected());
        }

        protected Rectangle getLabelRect(int n, Point point) {
            if (this.m_VBox.isSelected()) {
                return null;
            }
            int n2 = 400 + this.m_Spacing.getIntValue();
            return new Rectangle(point.x, point.y + n * n2, 1200, 400);
        }

        protected Rectangle getFieldRect(int n, Point point) {
            if (this.m_VBox.isSelected()) {
                return null;
            }
            int n2 = this.m_Labels.isSelected() ? 1200 : 0;
            int n3 = 400 + this.m_Spacing.getIntValue();
            return new Rectangle(point.x + n2, point.y + n * n3, 1200, 400);
        }
    }

    private final class HorizontalPanel
    extends LayoutPanel {
        private JCheckBox m_Labels;
        private JCheckBox m_LabelsInHeader;
        private JCheckBox m_HBox;
        private UnitField m_Spacing;
        private JComboBox m_LabelStyle;
        private JComboBox m_FieldStyle;

        public HorizontalPanel() {
            this.m_Labels = SwingFactory.newCheckBox("labels");
            this.m_LabelsInHeader = SwingFactory.newCheckBox("header");
            this.m_HBox = SwingFactory.newCheckBox("hbox");
            this.m_Spacing = new UnitField();
            this.m_Spacing.setColumns(5);
            this.m_LabelStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_FieldStyle = new JComboBox<String>(FieldLayoutWizard.this.m_Styles);
            this.m_Component.add(this.m_Labels);
            this.m_Component.add(this.m_LabelsInHeader);
            this.m_Component.add("hbox", this.m_HBox);
            this.m_Layout.addLabel((JComponent)this.m_Component, "spacing", SwingFactory.newLabel("spacing-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "lstyle", SwingFactory.newLabel("lstyle-label"));
            this.m_Layout.addLabel((JComponent)this.m_Component, "fstyle", SwingFactory.newLabel("fstyle-label"));
            this.m_Component.add("spacing", this.m_Spacing);
            this.m_Component.add("lstyle", this.m_LabelStyle);
            this.m_Component.add("fstyle", this.m_FieldStyle);
            this.m_Layout.stickTop("labels");
            this.m_Layout.stickLeft("labels");
            this.m_Layout.putRight("header", "labels", 15);
            this.m_Layout.vCenter("header", "labels");
            this.m_Layout.alignBelow("hbox", "labels");
            this.m_Layout.putBelow("spacing", "hbox", 10);
            this.m_Layout.putRight("spacing", "spacing-label,lstyle-label,fstyle-label", 10);
            this.m_Layout.alignBelow("lstyle", "spacing", 10);
            this.m_Layout.alignBelow("fstyle", "lstyle");
            this.m_Labels.addItemListener(this.m_Watcher);
            this.update();
        }

        @Override
        public void layoutFields(DataField[] dataFieldArray, Point point) {
            Object object;
            String string;
            HBox hBox = null;
            HBox hBox2 = null;
            String string2 = (String)this.m_LabelStyle.getSelectedItem();
            if (StringUtil.isEmpty(string2)) {
                string2 = null;
            }
            if (StringUtil.isEmpty(string = (String)this.m_FieldStyle.getSelectedItem())) {
                string = null;
            }
            if (this.m_HBox.isSelected()) {
                Chunk chunk = FieldLayoutWizard.this.m_ChunkPanel.getChunk();
                hBox2 = new HBox();
                hBox2.setName("Fields");
                object = new Rectangle(0, 0, FieldLayoutWizard.this.m_ChunkPanel.getChunkWidth(), 400);
                if (!this.m_LabelsInHeader.isSelected()) {
                    object.y += 400;
                }
                FieldLayoutWizard.this.createShape((BasicRawElementHolder)chunk, (RawModelElement)hBox2, (Rectangle)object);
                if (this.m_Labels.isSelected()) {
                    hBox = new HBox();
                    hBox.setName("Labels");
                    if (this.m_LabelsInHeader.isSelected()) {
                        chunk = FieldLayoutWizard.this.getHeader();
                        object.y = chunk.getHeight() - 400;
                    } else {
                        object.y -= 400;
                    }
                    FieldLayoutWizard.this.createShape((BasicRawElementHolder)chunk, (RawModelElement)hBox, (Rectangle)object);
                }
            }
            for (int i = 0; i < dataFieldArray.length; ++i) {
                Rectangle rectangle;
                Field field;
                if (this.m_Labels.isSelected()) {
                    object = FieldLayoutWizard.this.getLabelParent((Box)hBox, this.m_LabelsInHeader.isSelected());
                    field = FieldLayoutWizard.this.createLabel((BasicRawElementHolder)object, dataFieldArray[i], string2, true);
                    rectangle = this.getLabelRect(i);
                    FieldLayoutWizard.this.createShape((BasicRawElementHolder)object, (RawModelElement)field, rectangle);
                }
                object = FieldLayoutWizard.this.getFieldParent((Box)hBox2);
                field = FieldLayoutWizard.this.createField((BasicRawElementHolder)object, dataFieldArray[i], string, false);
                rectangle = this.getFieldRect(i);
                FieldLayoutWizard.this.createShape((BasicRawElementHolder)object, (RawModelElement)field, rectangle);
            }
            if (hBox != null) {
                ((HBoxShape)hBox.getShape()).layoutCells();
            }
            if (hBox2 != null) {
                ((HBoxShape)hBox2.getShape()).layoutCells();
                FieldLayoutWizard.this.m_ChunkPanel.getSelectionManager().setSelection((RawModelElement)hBox2);
            }
        }

        @Override
        public void update() {
            this.m_LabelsInHeader.setEnabled(FieldLayoutWizard.this.getHeader() != null && this.m_Labels.isSelected());
            this.m_LabelStyle.setEnabled(this.m_Labels.isSelected());
        }

        protected Rectangle getLabelRect(int n) {
            if (this.m_HBox.isSelected()) {
                return null;
            }
            int n2 = 0;
            if (this.m_LabelsInHeader.isSelected()) {
                n2 = FieldLayoutWizard.this.getHeader().getHeight() - 400;
            }
            int n3 = 1200 + this.m_Spacing.getIntValue();
            return new Rectangle(n * n3, n2, 1200, 400);
        }

        protected Rectangle getFieldRect(int n) {
            if (this.m_HBox.isSelected()) {
                return null;
            }
            int n2 = 0;
            if (!this.m_LabelsInHeader.isSelected()) {
                n2 += 400;
            }
            int n3 = 1200 + this.m_Spacing.getIntValue();
            return new Rectangle(n * n3, n2, 1200, 400);
        }
    }

    private abstract class LayoutPanel
    implements ILayoutPanel {
        protected JPanel m_Component;
        protected ArchLayout m_Layout;
        protected CodeBlock m_Watcher = new CodeBlock((Object)this, "update");

        public LayoutPanel() {
            this.m_Layout = new ArchLayout();
            this.m_Component = new JPanel(this.m_Layout);
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        public JComponent getComponent() {
            return this.m_Component;
        }

        public abstract void update();

        @Override
        public abstract void layoutFields(DataField[] var1, Point var2);
    }

    private static interface ILayoutPanel {
        public JComponent getComponent();

        public void layoutFields(DataField[] var1, Point var2);
    }
}

