/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.pagesetup;

import com.elixirtech.erd.reportdesigner.pagesetup.Paper;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.UnitField;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PageSetupEditor
extends JPanel
implements ChangeListener,
ItemListener,
DocumentListener {
    public static final UnitField.UnitType[] MEASURES = new UnitField.UnitType[]{new UnitField.UnitType("pixels", 20.0, 0), new UnitField.UnitType("twips", 1.0, 0), new UnitField.UnitType("inches", 1440.0, 2), new UnitField.UnitType("millimeters", 56.69291338582678, 0)};
    private static final Insets TITLE_INSETS = new Insets(4, 4, 4, 4);
    public static final int DEFAULT_MARGIN = 720;
    public static final int DEFAULT_GUTTER = 360;
    private PageSetup m_PageSetup;
    private JTextField m_Name;
    private JComboBox m_Paper;
    private JSpinner m_HorizontalPageCount = this.createIntSpinner("horizontal-count");
    private UnitField m_Width = UnitField.newUnitField(MEASURES, "width");
    private UnitField m_Height = UnitField.newUnitField(MEASURES, "height");
    private JRadioButton m_Portrait;
    private JRadioButton m_Landscape;
    private UnitField m_Left = UnitField.newUnitField(MEASURES, "left");
    private UnitField m_Top = UnitField.newUnitField(MEASURES, "top");
    private UnitField m_Right = UnitField.newUnitField(MEASURES, "right");
    private UnitField m_Bottom = UnitField.newUnitField(MEASURES, "bottom");
    private JSpinner m_ColumnCount = this.createIntSpinner("column-count");
    private JRadioButton m_DownThenAcross;
    private JRadioButton m_AcrossThenDown;
    private UnitField m_ColumnSeparation = UnitField.newUnitField(MEASURES, "column-sep");
    private UnitField m_RowSeparation = UnitField.newUnitField(MEASURES, "row-sep");
    private List<ChangeListener> m_Listeners = new ArrayList<ChangeListener>();
    private ChangeEvent m_ThisChangeEvent = new ChangeEvent(this);
    public static final Paper[] PAPERS = new Paper[]{new Paper(MediaSizeName.ISO_A4), new Paper(MediaSizeName.ISO_A3), new Paper(MediaSizeName.ISO_A5), new Paper(MediaSizeName.NA_LETTER), new Paper(MediaSizeName.NA_LEGAL), new Paper(MediaSizeName.ISO_B5), new Paper("custom")};

    public PageSetupEditor() {
        this.setLayout(new BoxLayout(this, 1));
        this.m_Name = SwingFactory.newTextField("name");
        this.m_DownThenAcross = SwingFactory.newRadioButton("down-across-label");
        this.m_AcrossThenDown = SwingFactory.newRadioButton("across-down-label");
        this.m_Portrait = SwingFactory.newRadioButton("RPT.portrait");
        this.m_Landscape = SwingFactory.newRadioButton("RPT.landscape");
        this.add(this.getPageName());
        this.add(this.getPageSize());
        this.add(this.getMargins());
        this.add(this.getColumns());
        this.add(Box.createVerticalGlue());
        I18N.ERD_MAP.injectComponents("PageSetupEditor.", this);
    }

    public PageSetupEditor(PageSetup pageSetup) {
        this();
        this.pageToUi(pageSetup);
        this.m_PageSetup = pageSetup;
    }

    public void setPageSetup(PageSetup pageSetup) {
        if (this.m_PageSetup != null) {
            this.uiToPage(this.m_PageSetup);
        }
        this.m_PageSetup = null;
        this.pageToUi(pageSetup);
        this.m_PageSetup = pageSetup;
    }

    public void commitChanges() {
        this.uiToPage(this.m_PageSetup);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_Listeners.remove(changeListener);
    }

    protected void fireChanged() {
        for (ChangeListener changeListener : this.m_Listeners) {
            changeListener.stateChanged(this.m_ThisChangeEvent);
        }
    }

    protected JComponent getPageName() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(PageSetupEditor.TITLE_INSETS.top, PageSetupEditor.TITLE_INSETS.left, PageSetupEditor.TITLE_INSETS.bottom, PageSetupEditor.TITLE_INSETS.right));
        jPanel.add(SwingFactory.newLabel("name-label"));
        jPanel.add(this.m_Name);
        this.m_Name.getDocument().addDocumentListener(this);
        return jPanel;
    }

    protected JComponent getPageSize() {
        JPanel jPanel = new JPanel(new GridLayout(5, 2));
        jPanel.setBorder(new TitledBorder(new JLabel(I18N.ERD.getString("PageSetupEditor.page-size.text")), TITLE_INSETS));
        jPanel.add(SwingFactory.newLabel("paper-label"));
        this.m_Paper = new JComboBox<Paper>(PAPERS);
        this.m_Paper.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PageSetupEditor.this.fillPaperValues();
                PageSetupEditor.this.update();
            }
        });
        jPanel.add(this.m_Paper);
        jPanel.add(SwingFactory.newLabel("width-label"));
        jPanel.add(this.m_Width);
        this.m_Width.addDocumentListener(this);
        this.m_Width.setIntValue(PAPERS[0].getWidth());
        jPanel.add(SwingFactory.newLabel("height-label"));
        jPanel.add(this.m_Height);
        this.m_Height.setIntValue(PAPERS[0].getHeight());
        this.m_Height.addDocumentListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Portrait);
        jPanel.add(this.m_Portrait);
        this.m_Portrait.addItemListener(this);
        buttonGroup.add(this.m_Landscape);
        jPanel.add(this.m_Landscape);
        this.m_Landscape.addItemListener(this);
        this.m_Portrait.setSelected(true);
        jPanel.add(SwingFactory.newLabel("horizontal-page-label"));
        jPanel.add(this.m_HorizontalPageCount);
        return jPanel;
    }

    protected JComponent getMargins() {
        JPanel jPanel = new JPanel(new GridLayout(4, 2));
        jPanel.setBorder(new TitledBorder(new JLabel(I18N.ERD.getString("PageSetupEditor.margins-label.text")), TITLE_INSETS));
        jPanel.add(SwingFactory.newLabel("left-label"));
        jPanel.add(this.m_Left);
        this.m_Left.setIntValue(720);
        this.m_Left.addDocumentListener(this);
        jPanel.add(SwingFactory.newLabel("top-label"));
        jPanel.add(this.m_Top);
        this.m_Top.setIntValue(720);
        this.m_Top.addDocumentListener(this);
        jPanel.add(SwingFactory.newLabel("right-label"));
        jPanel.add(this.m_Right);
        this.m_Right.setIntValue(720);
        this.m_Right.addDocumentListener(this);
        jPanel.add(SwingFactory.newLabel("bottom-label"));
        jPanel.add(this.m_Bottom);
        this.m_Bottom.setIntValue(720);
        this.m_Bottom.addDocumentListener(this);
        return jPanel;
    }

    protected JComponent getColumns() {
        JPanel jPanel = new JPanel(new GridLayout(4, 2));
        jPanel.setBorder(new TitledBorder(new JLabel(I18N.ERD.getString("PageSetupEditor.columns-label.text")), TITLE_INSETS));
        jPanel.add(SwingFactory.newLabel("PageSetupEditor.columns-count"));
        jPanel.add(this.m_ColumnCount);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_DownThenAcross);
        jPanel.add(this.m_DownThenAcross);
        this.m_DownThenAcross.addItemListener(this);
        this.m_DownThenAcross.setSelected(true);
        buttonGroup.add(this.m_AcrossThenDown);
        jPanel.add(this.m_AcrossThenDown);
        this.m_AcrossThenDown.addItemListener(this);
        jPanel.add(SwingFactory.newLabel("column-separation"));
        jPanel.add(this.m_ColumnSeparation);
        this.m_ColumnSeparation.addDocumentListener(this);
        jPanel.add(SwingFactory.newLabel("row-separation"));
        jPanel.add(this.m_RowSeparation);
        this.m_RowSeparation.addDocumentListener(this);
        return jPanel;
    }

    protected void fillPaperValues() {
        Paper paper = (Paper)this.m_Paper.getSelectedItem();
        if (this.m_Portrait.isSelected()) {
            this.m_Width.setIntValue(paper.getWidth());
            this.m_Height.setIntValue(paper.getHeight());
        } else {
            this.m_Height.setIntValue(paper.getWidth());
            this.m_Width.setIntValue(paper.getHeight());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Paper paper;
        Object object = itemEvent.getSource();
        if ((object == this.m_Portrait || object == this.m_Landscape) && (paper = (Paper)this.m_Paper.getSelectedItem()) != PAPERS[PAPERS.length - 1]) {
            this.fillPaperValues();
        }
        this.update();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
        this.checkEnabled();
    }

    protected void checkEnabled() {
        boolean bl = this.isEnabled();
        boolean bl2 = bl && this.m_Paper.getSelectedIndex() == PAPERS.length - 1;
        this.m_Width.setEnabled(bl2);
        this.m_Height.setEnabled(bl2);
        int n = ((Number)this.m_ColumnCount.getValue()).intValue();
        this.m_ColumnSeparation.setEnabled(bl && n > 1);
        this.m_DownThenAcross.setEnabled(bl && n > 1);
        this.m_AcrossThenDown.setEnabled(bl && n > 1);
        this.m_RowSeparation.setEnabled(bl && n > 1 && this.m_AcrossThenDown.isSelected());
    }

    protected void update() {
        this.checkEnabled();
        if (this.m_PageSetup != null) {
            this.uiToPage(this.m_PageSetup);
        }
        this.fireChanged();
    }

    protected void pageToUi(PageSetup pageSetup) {
        this.m_Name.setText(pageSetup.getName());
        this.m_Paper.setSelectedItem(this.getPaper(pageSetup.getPaper()));
        this.m_Width.setIntValue(pageSetup.getWidth());
        this.m_Height.setIntValue(pageSetup.getHeight());
        if ("Portrait".equals(pageSetup.getOrientation())) {
            this.m_Portrait.setSelected(true);
        } else {
            this.m_Landscape.setSelected(true);
        }
        this.m_HorizontalPageCount.setValue(pageSetup.getHorizontalPageCount());
        this.m_Left.setIntValue(pageSetup.getLeft());
        this.m_Top.setIntValue(pageSetup.getTop());
        this.m_Right.setIntValue(pageSetup.getRight());
        this.m_Bottom.setIntValue(pageSetup.getBottom());
        this.m_ColumnCount.setValue(pageSetup.getColumnCount());
        this.m_ColumnSeparation.setIntValue(pageSetup.getColumnSpacing());
        this.m_RowSeparation.setIntValue(pageSetup.getRowSpacing());
        if (pageSetup.isDownThenAcross()) {
            this.m_DownThenAcross.setSelected(true);
        } else {
            this.m_AcrossThenDown.setSelected(true);
        }
        this.checkEnabled();
    }

    protected void uiToPage(PageSetup pageSetup) {
        if (pageSetup != null) {
            pageSetup.setName(this.m_Name.getText());
            pageSetup.setPaper(((Paper)this.m_Paper.getSelectedItem()).getName());
            pageSetup.setWidth(this.m_Width.getIntValue());
            pageSetup.setHeight(this.m_Height.getIntValue());
            pageSetup.setOrientation(this.m_Portrait.isSelected() ? "Portrait" : "Landscape");
            pageSetup.setHorizontalPageCount(((Number)this.m_HorizontalPageCount.getValue()).intValue());
            pageSetup.setLeft(this.m_Left.getIntValue());
            pageSetup.setTop(this.m_Top.getIntValue());
            pageSetup.setRight(this.m_Right.getIntValue());
            pageSetup.setBottom(this.m_Bottom.getIntValue());
            pageSetup.setColumnCount(((Number)this.m_ColumnCount.getValue()).intValue());
            pageSetup.setColumnSpacing(this.m_ColumnSeparation.getIntValue());
            pageSetup.setRowSpacing(this.m_RowSeparation.getIntValue());
            pageSetup.setColumnLayout(this.m_AcrossThenDown.isSelected() ? "Across Then Down" : "Down Then Across");
        }
    }

    private JSpinner createIntSpinner(String string) {
        JSpinner jSpinner = SwingFactory.newSpinner(string, new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        jSpinner.setBorder(null);
        jSpinner.addChangeListener(this);
        return jSpinner;
    }

    private Paper getPaper(String string) {
        for (int i = 0; i < PAPERS.length; ++i) {
            if (!PAPERS[i].getName().equals(string)) continue;
            return PAPERS[i];
        }
        return PAPERS[PAPERS.length - 1];
    }
}

