/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.pagesetup;

import com.elixirtech.erd.reportdesigner.pagesetup.PageSetupEditor;
import com.elixirtech.erd.reportdesigner.pagesetup.PageView;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.OnePageWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PageSetupPage
extends WizardPage
implements OnePageWizard.Page,
ChangeListener {
    private RawReport m_Report;
    private PageSetup m_PageSetup;
    private PageSetup m_WorkingPageSetup;
    private PageSetupEditor m_Editor;
    private PageView m_View;

    public static IWizard getWizard(RawReport rawReport, PageSetup pageSetup) {
        OnePageWizard onePageWizard = new OnePageWizard(I18N.ERD.getString("PageSetupPageWizard.title"), new PageSetupPage(rawReport, pageSetup));
        onePageWizard.setStandardSize(false);
        return onePageWizard;
    }

    public PageSetupPage(RawReport rawReport, PageSetup pageSetup) {
        super("PageSetup", null);
        this.m_Report = rawReport;
        this.m_PageSetup = pageSetup;
        try {
            this.m_WorkingPageSetup = (PageSetup)this.m_PageSetup.shallowCopy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Component.setLayout(new BorderLayout());
        this.m_Editor = new PageSetupEditor(this.m_WorkingPageSetup);
        this.m_View = new PageView(this.m_WorkingPageSetup);
        this.m_View.setPreferredSize(this.m_Editor.getPreferredSize());
        this.m_Editor.addChangeListener(this.m_View);
        this.m_Editor.addChangeListener(this);
        this.m_Component.add((Component)this.m_Editor, "West");
        this.m_Component.add((Component)this.m_View, "Center");
        I18N.ERD_MAP.injectObject(null, this, "PageSetupPage");
        if (this.m_Report.getSecurity().isReadOnly()) {
            iWizard.setReadOnly(true);
            this.m_Editor.setEnabled(false);
        }
    }

    @Override
    public boolean isPageComplete() {
        this.setError(null);
        boolean bl = true;
        String string = this.m_WorkingPageSetup.getName();
        if (StringUtil.isEmpty(string)) {
            this.setError(I18N.ERD.getString("Wizard.name-required"));
            bl = false;
        } else if (!string.equals(this.m_PageSetup.getName()) && this.m_Report.getPageSetup(string) != null) {
            this.setError(I18N.ERD.getString("Wizard.name-notunique"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public boolean performFinish() {
        this.m_PageSetup.copyFrom(this.m_WorkingPageSetup);
        this.m_Report.setDirty(true);
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.m_Wizard.getContainer().updateButtons();
    }
}

