/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.pagesetup;

import com.elixirtech.report2.raw.model.PageSetup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PageView
extends JComponent
implements ChangeListener {
    protected static final int PAGE_GAP = 360;
    protected static final int VIEW_MARGIN = 20;
    protected PageSetup m_PageSetup;

    public PageView() {
    }

    public PageView(PageSetup pageSetup) {
        this.m_PageSetup = pageSetup;
    }

    public void setPageSetup(PageSetup pageSetup) {
        this.m_PageSetup = pageSetup;
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public Dimension getPaperSize() {
        return new Dimension(this.m_PageSetup.getWidth(), this.m_PageSetup.getHeight());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setColor(Color.gray);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (this.m_PageSetup != null) {
            int n;
            int n2;
            double d;
            int n3 = 0;
            int n4 = 0;
            Dimension dimension2 = this.getPaperSize();
            int n5 = this.m_PageSetup.getHorizontalPageCount();
            int n6 = dimension2.width * n5 + 360 * n5 - 1;
            double d2 = (double)(dimension.width - 40) / (double)n6;
            if (d2 < (d = (double)(dimension.height - 40) / (double)dimension2.height)) {
                graphics2D.scale(d2, d2);
                n3 = (int)(((double)dimension.width / d2 - (double)n6) / 2.0);
                n4 = (int)(((double)dimension.height / d2 - (double)dimension2.height) / 2.0);
            } else {
                graphics2D.scale(d, d);
                n3 = (int)(((double)dimension.width / d - (double)n6) / 2.0);
                n4 = (int)(((double)dimension.height / d - (double)dimension2.height) / 2.0);
            }
            int n7 = this.m_PageSetup.getColumnCount();
            int n8 = 0;
            int n9 = 0;
            if (n7 > 1) {
                n2 = this.m_PageSetup.getLeft();
                n = this.m_PageSetup.getRight();
                int n10 = (dimension2.width - n - n2) * n5;
                n8 = this.m_PageSetup.getColumnSpacing();
                n9 = (n10 - (n7 - 1) * n8) / n7;
            }
            n2 = 0;
            for (n = 0; n < n5; ++n) {
                graphics2D.translate(n3, n4);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, dimension2.width, dimension2.height);
                this.drawMargins(graphics2D);
                if (n7 > 1) {
                    n2 = this.drawColumns(graphics2D, n2, n9, n8);
                }
                graphics2D.translate(-n3, -n4);
                n3 += dimension2.width + 360;
            }
        }
    }

    protected void drawMargins(Graphics2D graphics2D) {
        graphics2D.setColor(Color.blue);
        Dimension dimension = this.getPaperSize();
        int n = this.m_PageSetup.getLeft();
        int n2 = this.m_PageSetup.getRight();
        int n3 = this.m_PageSetup.getTop();
        int n4 = this.m_PageSetup.getBottom();
        graphics2D.drawLine(n, 0, n, dimension.height);
        graphics2D.drawLine(dimension.width - n2, 0, dimension.width - n2, dimension.height);
        graphics2D.drawLine(0, n3, dimension.width, n3);
        graphics2D.drawLine(0, dimension.height - n4, dimension.width, dimension.height - n4);
    }

    protected int drawColumns(Graphics2D graphics2D, int n, int n2, int n3) {
        if (n2 + n3 > 20) {
            int n4 = this.m_PageSetup.getLeft();
            int n5 = n4 + n;
            int n6 = this.m_PageSetup.getWidth() - this.m_PageSetup.getRight();
            int n7 = this.m_PageSetup.getTop();
            int n8 = this.m_PageSetup.getHeight() - this.m_PageSetup.getBottom();
            graphics2D.setColor(Color.gray);
            if ((n5 -= n3) >= n4) {
                graphics2D.drawLine(n5, n7, n5, n8);
            }
            n5 += n3;
            while (n5 < n6) {
                graphics2D.drawLine(n5, n7, n5, n8);
                if ((n5 += n2) <= n6) {
                    graphics2D.drawLine(n5, n7, n5, n8);
                }
                if ((n5 += n3) > n6) continue;
                graphics2D.drawLine(n5, n7, n5, n8);
            }
            return n5 - n6;
        }
        return 0;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(60, 60);
    }
}

