/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.property;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.erd.reportdesigner.property.WizardRenderer;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ControlSourceRenderer
extends WizardRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        ControlSource controlSource = (ControlSource)this.m_Node.getValue();
        if (controlSource == null) {
            this.setText("");
        } else {
            this.setText(controlSource.getText());
        }
        return this.m_Panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ControlSource controlSource = (ControlSource)this.m_Node.getValue();
        if (controlSource == null) {
            this.setText("");
        } else {
            this.setText(controlSource.getText());
        }
        return this.m_Panel;
    }

    @Override
    public Object getCellValue() {
        return this.m_Node.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_Dots) {
            if (this.openPropertyDialog()) {
                this.m_Editor.fireEditingStopped();
            } else {
                this.m_Editor.fireEditingCancelled();
            }
        }
    }

    protected boolean openPropertyDialog() {
        List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
        if (list.size() == 1) {
            PropertyHolder propertyHolder = list.get(0);
            if (propertyHolder instanceof RawModelElement) {
                RawModelElement rawModelElement = (RawModelElement)propertyHolder;
                UiElementBeanFactory.showPropertyDialog(rawModelElement, this.m_Node.getName().getName(), false);
                return true;
            }
        } else {
            ElixirJ.warn(I18N.ERD.getString("ControlSourceRenderer.error-open"));
        }
        return false;
    }
}

