/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.property;

import com.elixirtech.property.PropertyNode;
import com.elixirtech.ui.FileLoadDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class FilePathRenderer
extends JTextField
implements IPropertyRenderer,
ActionListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;
    private JPanel m_Panel;
    private JButton m_Dots;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType().getTypeId() != 203) {
            throw new IllegalArgumentException("Expected a FilePath property");
        }
        this.setBorder(null);
        this.addActionListener(this);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.add(this);
        this.m_Dots = SwingFactory.newDotsButton(this);
        this.m_Dots.setBorder(null);
        this.m_Dots.setBackground(UIManager.getColor("TextField.background"));
        this.m_Panel.add((Component)this.m_Dots, "East");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        String string = (String)this.m_Node.getValue();
        if (string == null) {
            this.setText("");
        } else {
            this.setText(string);
        }
        return this.m_Panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = (String)this.m_Node.getValue();
        if (string == null) {
            this.setText("");
        } else {
            this.setText(string);
        }
        return this.m_Panel;
    }

    @Override
    public Object getCellValue() {
        return this.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_Dots) {
            FileLoadDialog fileLoadDialog = new FileLoadDialog();
            fileLoadDialog.setDialogTitle(this.m_Node.getName().getLabel());
            int n = fileLoadDialog.showDialog(this, "OK");
            if (n == 0) {
                this.setText(fileLoadDialog.getSelectedFile().getAbsolutePath());
            }
        }
        this.m_Editor.fireEditingStopped();
    }
}

