/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.property;

import com.elixirtech.property.PropertyNode;
import com.elixirtech.ui.ComboUtil;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class LocaleRenderer
extends JComboBox<Object>
implements IPropertyRenderer,
ItemListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;
    private static Locale[] CHOICES;
    static Color m_SelectedBackground;
    static Color m_Background;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType().getTypeId() != 201) {
            throw new IllegalArgumentException("Expected a Locale property");
        }
        ComboUtil.stripComboBorder(this);
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setFont(UIManager.getFont("TextField.font"));
        this.addItemListener(this);
        this.setRenderer(new LocaleComboRenderer());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        this.setModel(new DefaultComboBoxModel<Object>(this.getChoices()));
        Locale locale = (Locale)this.m_Node.getValue();
        this.setSelectedItem(locale);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setModel(new DefaultComboBoxModel<Object>(this.getChoices()));
        Locale locale = (Locale)this.m_Node.getValue();
        this.setSelectedItem(locale);
        return this;
    }

    @Override
    public Object getCellValue() {
        return this.getSelectedItem();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_Editor.fireEditingStopped();
    }

    private Object[] getChoices() {
        return CHOICES;
    }

    static {
        Locale[] localeArray = Locale.getAvailableLocales();
        Arrays.sort(localeArray, new LocaleComparator());
        CHOICES = new Locale[localeArray.length + 1];
        System.arraycopy(localeArray, 0, CHOICES, 1, localeArray.length);
        m_SelectedBackground = UIManager.getColor("ComboBox.selectionBackground");
        m_Background = UIManager.getColor("TextField.background");
    }

    private static class LocaleComboRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public LocaleComboRenderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("TextField.font"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Locale locale = (Locale)object;
            if (locale == null) {
                this.setText("Default");
            } else {
                this.setText(locale.getDisplayName());
            }
            this.setBackground(bl ? m_SelectedBackground : m_Background);
            return this;
        }
    }

    private static class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale locale, Locale locale2) {
            String string = locale.getDisplayName();
            String string2 = locale2.getDisplayName();
            return string.compareTo(string2);
        }
    }
}

