/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.property;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.erd.reportdesigner.ReportTab;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ScriptRenderer
extends JTextField
implements IPropertyRenderer,
ActionListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;
    private JPanel m_Panel;
    private JButton m_Dots;
    private Script m_CurrentScript;

    public ScriptRenderer() {
        this.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.add(this);
        this.m_Dots = SwingFactory.newDotsButton(this);
        this.m_Dots.setBorder(null);
        this.m_Dots.setBackground(UIManager.getColor("TextField.background"));
        this.m_Panel.add((Component)this.m_Dots, "East");
    }

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType().getTypeId() != 202) {
            throw new IllegalArgumentException("Expected a Script property");
        }
        this.setBorder(null);
        this.addActionListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        this.m_CurrentScript = (Script)this.m_Node.getValue();
        if (this.m_CurrentScript == null) {
            this.setText("");
        } else {
            String string = this.m_CurrentScript.getText();
            if (this.isMultiline(string)) {
                this.setEnabled(false);
                this.setText("<multiline>");
            } else {
                this.setEnabled(true);
                this.setText(string);
            }
        }
        this.m_Dots.setEnabled(this.m_Editor.getPropertyHolders().size() == 1);
        return this.m_Panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.m_CurrentScript = (Script)this.m_Node.getValue();
        if (this.m_CurrentScript == null) {
            this.setText("");
        } else {
            String string = this.m_CurrentScript.getText();
            if (this.isMultiline(string)) {
                this.setEnabled(false);
                this.setText("<multiline>");
            } else {
                this.setEnabled(true);
                this.setText(string);
            }
        }
        this.m_Dots.setEnabled(this.m_Editor.getPropertyHolders().size() == 1);
        return this.m_Panel;
    }

    @Override
    public Object getCellValue() {
        if (!this.isEnabled()) {
            return this.m_CurrentScript;
        }
        return new Script("javascript", this.getText());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_Dots) {
            this.m_Editor.fireEditingStopped();
            List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
            if (list.size() > 0) {
                PropertyHolder propertyHolder = list.get(0);
                Property property = propertyHolder.getProperty(this.m_Node.getName());
                if (this.canShowFunction()) {
                    this.showFunction(propertyHolder, property);
                } else {
                    this.showPopup(propertyHolder, property);
                }
            }
        } else {
            this.m_Editor.fireEditingStopped();
        }
    }

    protected boolean isMultiline(String string) {
        return string.trim().indexOf("\n") >= 0;
    }

    protected boolean canShowFunction() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        return !elixirFrame.isModalShowing();
    }

    protected void showFunction(PropertyHolder propertyHolder, Property property) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        ReportTab reportTab = (ReportTab)iViewModel.getCurrentView();
        reportTab.showFunction(propertyHolder, property);
    }

    protected void showPopup(PropertyHolder propertyHolder, Property property) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        ScriptDialog scriptDialog = new ScriptDialog(elixirFrame.getFrame(), property);
        elixirFrame.showModal(scriptDialog);
    }

    public static class ScriptDialog
    extends JDialog {
        private Property m_Property;
        private JEditor m_Editor;

        public ScriptDialog(JFrame jFrame, Property property) {
            super(jFrame, property.getShortLabel(), true);
            this.m_Property = property;
            this.setDefaultCloseOperation(2);
            JComponent jComponent = (JComponent)this.getContentPane();
            jComponent.setLayout(new BorderLayout());
            jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Script script = (Script)this.m_Property.getValue();
            String string = script != null ? script.getText() : "";
            this.m_Editor = new JEditor(string, REJavaScriptTypes.kit());
            jComponent.add((Component)new JScrollPane(this.m_Editor), "Center");
            JPanel jPanel = new JPanel();
            JButton jButton = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
            JButton jButton2 = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jComponent.add((Component)jPanel, "South");
            jComponent.setPreferredSize(new Dimension(500, 300));
            this.pack();
            this.setLocationRelativeTo(jFrame);
        }

        public void ok() {
            this.m_Property.setValue((Object)new Script("javascript", this.m_Editor.getText()));
            this.dispose();
        }

        public void cancel() {
            this.dispose();
        }
    }
}

