/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.property;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class WizardRenderer
extends JTextField
implements IPropertyRenderer,
ActionListener {
    protected PropertyTableEditor m_Editor;
    protected PropertyNode m_Node;
    protected JPanel m_Panel;
    protected JButton m_Dots;

    public WizardRenderer() {
        this.setEnabled(false);
        this.addMouseListener(new ML());
    }

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        this.setBorder(null);
        this.addActionListener(this);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.add(this);
        this.m_Dots = SwingFactory.newDotsButton();
        this.m_Dots.setBorder(null);
        this.m_Dots.setBackground(UIManager.getColor("TextField.background"));
        this.m_Dots.addActionListener(this);
        this.m_Panel.add((Component)this.m_Dots, "East");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        String string = (String)this.m_Node.getValue();
        if (string == null) {
            this.setText("");
        } else {
            this.setText(string);
        }
        return this.m_Panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = (String)this.m_Node.getValue();
        if (string == null) {
            this.setText("");
        } else {
            this.setText(string);
        }
        return this.m_Panel;
    }

    @Override
    public Object getCellValue() {
        return this.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_Dots) {
            this.openWizard();
        }
        this.m_Editor.fireEditingStopped();
    }

    protected void openWizard() {
        List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
        if (list.size() == 1) {
            PropertyHolder propertyHolder = list.get(0);
            if (propertyHolder instanceof RawModelElement) {
                RawModelElement rawModelElement = (RawModelElement)propertyHolder;
                UiElementBeanFactory.showWizard(rawModelElement, this.m_Node.getName().getName(), false);
            }
        } else {
            ElixirJ.warn(I18N.ERD.getString("Error.multiple-selection"));
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                WizardRenderer.this.openWizard();
            }
        }
    }
}

