/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.barcode.BasicBarcodeRenderer;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.RawElement;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class BarcodeRenderer
extends UiElementRenderer {
    private double m_OldWidth;
    private double m_OldHeight;
    private String m_OldBackgroundColor;

    @Override
    protected void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        Barcode barcode = (Barcode)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        if (rectangle.width > 0 && rectangle.height > 0) {
            Object object;
            Image image = barcode.getImage();
            String string = barcode.getBackgroundColor();
            if (string != null && !string.equals(this.m_OldBackgroundColor)) {
                image = null;
            } else if (rectangle.getHeight() != this.m_OldHeight || rectangle.getWidth() == this.m_OldWidth) {
                image = null;
            }
            if (image == null) {
                object = barcode.deepCopy();
                object.setImageResolution(72);
                new BasicBarcodeRenderer().render((Barcode)object, this.getText(barcode));
                image = object.getImage();
                barcode.setImage(image);
                this.m_OldWidth = rectangle.getWidth();
                this.m_OldHeight = rectangle.getHeight();
                this.m_OldBackgroundColor = barcode.getBackgroundColor();
            }
            if (image != null) {
                object = renderContext.getGraphics();
                int n = image.getWidth(null);
                int n2 = image.getHeight(null);
                Dimension dimension = new Dimension(n * 20, n2 * 20);
                int n3 = Alignment.CENTER.ID;
                Point point = Alignment.getTopLeft((Dimension)dimension, (Rectangle)rectangle, (int)n3);
                double d = barcode.getImageResolution();
                ((Graphics)object).drawImage(image, point.x, point.y, dimension.width, dimension.height, null);
            }
        }
    }

    public String getText(Barcode barcode) {
        return BasicBarcodeRenderer.getSampleData((Barcode)barcode);
    }

    @Override
    protected boolean hasCurvedClip() {
        return true;
    }
}

