/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartDataFactory;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.ChartRenderFactory;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.sax.CMLSAXUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.RecordExtractor;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chart;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingWorker;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;

public class ChartRenderer
extends UiElementRenderer {
    private static Map<Chart, Dimension> m_Loaders = new HashMap<Chart, Dimension>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartRenderer.class);

    @Override
    public void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        Chart chart = (Chart)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        int n = rectangle.width / 20;
        int n2 = rectangle.height / 20;
        Graphics2D graphics2D = renderContext.getGraphics();
        if (!chart.isPreview()) {
            graphics2D.scale(20.0, 20.0);
            Font font = new Font("SansSerif", 0, 12);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.black);
            int n3 = rectangle.x / 20;
            int n4 = rectangle.y / 20;
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            ERDIcons.CHART.paintIcon(elixirFrame.getFrame(), graphics2D, n3 + 5, n4 + 5);
            graphics2D.drawString(I18N.ERD.getString("ChartRenderer.PREVIEW_DISABLED"), (n3 += ERDIcons.CHART.getIconWidth() + 5) + 5, n4 + fontMetrics.getHeight() + 5);
            graphics2D.scale(0.05, 0.05);
            return;
        }
        Image image = chart.getImage();
        if (image == null || image.getWidth(null) != n || image.getHeight(null) != n2) {
            graphics2D.scale(20.0, 20.0);
            Font font = new Font("SansSerif", 0, 12);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.black);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(I18N.ERD.getString("ChartRenderer.PREPARING_CHART"), rectangle.x / 20 + 5, rectangle.y / 20 + fontMetrics.getHeight() + 5);
            graphics2D.scale(0.05, 0.05);
            ChartRenderer.loadAsync(chart, renderContext.getReport(), renderContext.getChunk(), n, n2);
        } else {
            graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        }
    }

    private static synchronized void loadAsync(Chart chart, RawReport rawReport, Chunk chunk, int n, int n2) {
        Dimension dimension = m_Loaders.get(chart);
        if (dimension != null) {
            dimension.width = n;
            dimension.height = n2;
        } else {
            dimension = new Dimension(n, n2);
            m_Loaders.put(chart, dimension);
            new ChartLoader(chart, rawReport, chunk, dimension).start();
        }
    }

    static synchronized void removeLoader(Chart chart) {
        m_Loaders.remove(chart);
    }

    static void loadImage(RawReport rawReport, Section section, Chart chart, Dimension dimension) {
        String string = chart.getChartURL();
        com.elixirtech.chart2.model.Chart chart2 = null;
        RMLFileObject rMLFileObject = null;
        try {
            if (string != null && string.length() > 1) {
                if (string.startsWith("repository:")) {
                    string = string.substring("repository:".length());
                }
                rMLFileObject = rawReport.getFile(string);
                chart2 = CMLSAXUtil.read((RMLFileObject)rMLFileObject);
            } else {
                chart2 = CMLSAXUtil.readFromRML((Chart)chart);
            }
        }
        catch (IOException iOException) {
            m_Log.error((Object)"Unable to load chart information", (Throwable)iOException);
            return;
        }
        catch (JDOMException jDOMException) {
            m_Log.error((Object)"Unable to load chart information", (Throwable)jDOMException);
            return;
        }
        try {
            Object object;
            DataRecord dataRecord;
            DataSource dataSource;
            assert (chart2 != null);
            assert (chart2.getChartType() != null);
            chart2.setLocale(chart.getLocale());
            Color color = StandardColor.lookup(chart.getBackgroundColor(), (Color)null);
            chart2.setBackgroundColor(color);
            AbstractChartRenderer abstractChartRenderer = ChartRenderFactory.getRenderer((IChart)chart2);
            String string2 = chart.getDataSource();
            if (StringUtil.notEmpty(string2)) {
                dataSource = rawReport.getDataSource(string2);
                string2 = dataSource != null ? dataSource.getDataSourceName() : null;
            }
            if (StringUtil.isEmpty(string2)) {
                string2 = ChartRenderer.getDefaultDS(rawReport, section);
            }
            dataSource = null;
            if ("Record".equals(chart.getDataRange())) {
                dataRecord = ChartRenderer.getFirstRecord(string2);
                if (dataRecord != null) {
                    object = new DataTable("dummy", dataRecord.getSchema(), new DataRecord[]{dataRecord});
                    dataSource = ChartDataFactory.getDatasetHolder((DataTable)object, (IChart)chart2);
                }
            } else {
                dataSource = ChartDataFactory.getDatasetHolder((String)string2, (IChart)chart2);
            }
            if (dataSource != null) {
                dataRecord = abstractChartRenderer.getChart(null, (DatasetHolder)dataSource);
                object = new BufferedImage(dimension.width, dimension.height, 2);
                Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                if (dataRecord != null) {
                    dataRecord.draw(graphics2D, (Rectangle2D)new Rectangle(0, 0, dimension.width, dimension.height), new ChartRenderingInfo());
                    graphics2D.dispose();
                } else {
                    Font font = new Font("SansSerif", 0, 12);
                    graphics2D.setFont(font);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString(I18N.ERD.getString("ChartRenderer.ERROR_CHART"), 10, 50);
                }
                chart.setImage((Image)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static String getDefaultDS(RawReport rawReport, Section section) {
        String string = section.getDataSource();
        if (StringUtil.notEmpty(string)) {
            DataSource dataSource = rawReport.getDataSource(string);
            return dataSource.getDataSourceName();
        }
        return "";
    }

    @Override
    protected boolean hasCurvedClip() {
        return true;
    }

    protected static DataRecord getFirstRecord(String string) {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
            return RecordExtractor.getRecord((IDataSource)iDataSource, (int)0);
        }
        catch (DataException dataException) {
            m_Log.error((Object)("getFirstRecord: " + String.valueOf((Object)dataException)), (Throwable)dataException);
            return null;
        }
    }

    private static class ChartLoader
    extends SwingWorker {
        private Chart m_Chart;
        private RawReport m_Report;
        private Chunk m_Chunk;
        private Dimension m_Dimension;

        public ChartLoader(Chart chart, RawReport rawReport, Chunk chunk, Dimension dimension) {
            this.m_Chart = chart;
            this.m_Report = rawReport;
            this.m_Chunk = chunk;
            this.m_Dimension = dimension;
        }

        @Override
        public Object construct() {
            ChartRenderer.loadImage(this.m_Report, this.m_Chunk.getSection(), this.m_Chart, this.m_Dimension);
            return null;
        }

        @Override
        public void finished() {
            super.finished();
            ChartRenderer.removeLoader(this.m_Chart);
            Image image = this.m_Chart.getImage();
            if (image != null) {
                this.m_Chunk.repaint();
            }
        }
    }
}

