/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.CheckBox;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.util.ImageLoader;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class CheckBoxRenderer
extends UiElementRenderer {
    @Override
    public void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        CheckBox checkBox = (CheckBox)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        Image image = checkBox.getImage();
        if (image == null && !checkBox.isLoadError()) {
            this.loadImage(checkBox);
            image = checkBox.getImage();
        }
        if (image != null) {
            Graphics2D graphics2D = renderContext.getGraphics();
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            Dimension dimension = new Dimension(n * 20, n2 * 20);
            int n3 = Alignment.getAlignmentId((String)checkBox.getHorizontalAlign(), (String)checkBox.getVerticalAlign());
            Point point = Alignment.getTopLeft((Dimension)dimension, (Rectangle)rectangle, (int)n3);
            graphics2D.drawImage(image, point.x, point.y, dimension.width, dimension.height, null);
        }
    }

    public void loadImage(CheckBox checkBox) {
        Image image = checkBox.getImage();
        ControlSource controlSource = checkBox.getOnImage();
        String string = controlSource.getType();
        if ("URL".equals(string)) {
            IResourceProvider iResourceProvider = checkBox.getResourceProvider();
            String string2 = controlSource.getURL();
            Image image2 = ImageLoader.getImage((IResourceProvider)iResourceProvider, (String)string2);
            if (image != null && image != image2) {
                image.flush();
            }
            checkBox.setImage(image2);
            checkBox.setLoadError(image2 == null);
        } else {
            if (image != null) {
                image.flush();
            }
            checkBox.setImage(null);
            checkBox.setLoadError(true);
        }
    }

    @Override
    protected boolean hasPaddedClip() {
        return true;
    }
}

