/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.data.ChartDataFactory;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.renderer.ComboChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.DatasetHolders;
import com.elixirtech.chart2.renderer.MultiAxisChartRenderer;
import com.elixirtech.chart2.sax.CMLSAXUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.RecordExtractor;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.DataScope;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.SwingWorker;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;

public class CompositeChartRenderer
extends UiElementRenderer {
    private static Map<com.elixirtech.report2.raw.model.CompositeChart, Dimension> m_Loaders = new HashMap<com.elixirtech.report2.raw.model.CompositeChart, Dimension>();
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CompositeChartRenderer.class);

    @Override
    public void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        com.elixirtech.report2.raw.model.CompositeChart compositeChart = (com.elixirtech.report2.raw.model.CompositeChart)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        int n = rectangle.width / 20;
        int n2 = rectangle.height / 20;
        if (!compositeChart.isPreview()) {
            Graphics2D graphics2D = renderContext.getGraphics();
            graphics2D.scale(20.0, 20.0);
            Font font = new Font("SansSerif", 0, 12);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.black);
            int n3 = rectangle.x / 20;
            int n4 = rectangle.y / 20;
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            ERDIcons.CHART.paintIcon(elixirFrame.getFrame(), graphics2D, n3 + 5, n4 + 5);
            graphics2D.drawString(I18N.ERD.getString("ChartRenderer.PREVIEW_DISABLED"), (n3 += ERDIcons.CHART.getIconWidth() + 5) + 5, n4 + fontMetrics.getHeight() + 5);
            graphics2D.scale(0.05, 0.05);
            return;
        }
        Image image = compositeChart.getImage();
        if (image == null || image.getWidth(null) != n || image.getHeight(null) != n2) {
            Graphics2D graphics2D = renderContext.getGraphics();
            graphics2D.scale(20.0, 20.0);
            Font font = new Font("SansSerif", 0, 12);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.black);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(I18N.ERD.getString("ChartRenderer.PREPARING_CHART"), rectangle.x / 20 + 5, rectangle.y / 20 + fontMetrics.getHeight() + 5);
            graphics2D.scale(0.05, 0.05);
            this.loadAsync(compositeChart, renderContext.getReport(), renderContext.getChunk(), n, n2);
        } else {
            Graphics2D graphics2D = renderContext.getGraphics();
            graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        }
    }

    private void loadAsync(com.elixirtech.report2.raw.model.CompositeChart compositeChart, RawReport rawReport, Chunk chunk, int n, int n2) {
        Dimension dimension = m_Loaders.get(compositeChart);
        if (dimension != null) {
            dimension.width = n;
            dimension.height = n2;
        } else {
            dimension = new Dimension(n, n2);
            m_Loaders.put(compositeChart, dimension);
            new ChartLoader(this, compositeChart, rawReport, chunk, dimension).start();
        }
    }

    private void loadImage(RawReport rawReport, Section section, com.elixirtech.report2.raw.model.CompositeChart compositeChart, Dimension dimension) {
        String string = compositeChart.getChartURL();
        CompositeChart compositeChart2 = null;
        try {
            if (string != null && string.length() > 1) {
                throw new IOException("Not implemented");
            }
            compositeChart2 = CMLSAXUtil.readCompositeChartFromRML((com.elixirtech.report2.raw.model.CompositeChart)compositeChart);
        }
        catch (IOException iOException) {
            m_Log.error((Object)"Unable to load chart information", (Throwable)iOException);
            return;
        }
        catch (JDOMException jDOMException) {
            m_Log.error((Object)"Unable to load chart information", (Throwable)jDOMException);
            return;
        }
        try {
            assert (compositeChart2 != null);
            assert (compositeChart2.getChartType() != null);
            JFreeChart jFreeChart = this.getChart(compositeChart2, compositeChart);
            if (jFreeChart != null) {
                BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                jFreeChart.draw(graphics2D, (Rectangle2D)new Rectangle(0, 0, dimension.width, dimension.height), new ChartRenderingInfo());
                graphics2D.dispose();
                compositeChart.setImage((Image)bufferedImage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JFreeChart getChart(CompositeChart compositeChart, com.elixirtech.report2.raw.model.CompositeChart compositeChart2) throws ChartException {
        String string = compositeChart.getCategory();
        DatasetHolders datasetHolders = this.getData(compositeChart, compositeChart2);
        if ("Combo".equals(string)) {
            ComboChartRenderer comboChartRenderer = new ComboChartRenderer((IChart)compositeChart);
            return comboChartRenderer.getChart(null, datasetHolders);
        }
        if ("MultiAxis".equals(string)) {
            MultiAxisChartRenderer multiAxisChartRenderer = new MultiAxisChartRenderer((IChart)compositeChart);
            return multiAxisChartRenderer.getChart(null, datasetHolders);
        }
        return null;
    }

    protected DatasetHolders getData(CompositeChart compositeChart, com.elixirtech.report2.raw.model.CompositeChart compositeChart2) {
        Section section = compositeChart2.getChunk().getSection();
        String string = section.getDataSource();
        List list = compositeChart.getSubPlotList();
        int n = list.size();
        DatasetHolders datasetHolders = new DatasetHolders();
        CompositeChartType compositeChartType = (CompositeChartType)compositeChart.getChartType();
        boolean bl = compositeChartType.isInverted();
        boolean bl2 = compositeChartType.isRetainKeyOrder();
        ChartType chartType = compositeChart.getChartType();
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            CategoryType categoryType;
            SubPlot subPlot = compositeChart.getSubPlot(i);
            DataScope dataScope = subPlot.getDataScope();
            String string4 = dataScope.getDataSourceName();
            if (StringUtil.isEmpty(string4)) {
                string4 = string;
            }
            DataSource dataSource = section.getRawReport().getDataSource(string4);
            string4 = dataSource.getDataSourceName();
            ChartType chartType2 = subPlot.getChartType();
            if (chartType2 instanceof CategoryType) {
                categoryType = (CategoryType)chartType2;
                categoryType.setInverted(bl);
                categoryType.setRetainKeyOrder(bl2);
            }
            categoryType = null;
            DSPair dSPair = CompositeChartRenderer.getFewRecords(string4);
            DataTable dataTable = new DataTable("dummy", dSPair.ds, dSPair.rs);
            if (i == 0) {
                JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
                string2 = DataUtil.buildChartText((JavaScriptEngine)javaScriptEngine, (DataTable)dataTable, (IControlSourceHolder)chartType.getTitle());
                string3 = DataUtil.buildChartText((JavaScriptEngine)javaScriptEngine, (DataTable)dataTable, (IControlSourceHolder)chartType.getLegend());
            }
            categoryType = ChartDataFactory.getDatasetHolder((DataTable)dataTable, (String)subPlot.getType(), (ChartType)chartType2);
            datasetHolders.add((DatasetHolder)categoryType);
        }
        if (n == 0) {
            string2 = chartType.getTitle().getControlSource().getText();
            string3 = chartType.getLegend().getControlSource().getText();
        }
        datasetHolders.setTitle(string2);
        datasetHolders.setLegend(string3);
        return datasetHolders;
    }

    protected static DSPair getFewRecords(String string) {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        ArrayList<DataRecord> arrayList = new ArrayList<DataRecord>();
        DSPair dSPair = new DSPair();
        try {
            DataRecord dataRecord;
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
            dSPair.ds = iDataSource.getSchema();
            for (int i = 0; i < 10 && (dataRecord = RecordExtractor.getRecord((IDataSource)iDataSource, (int)i)) != null; ++i) {
                arrayList.add(dataRecord);
            }
            dSPair.rs = arrayList.toArray(new DataRecord[arrayList.size()]);
        }
        catch (DataException dataException) {
            m_Log.error((Object)("getFirstRecord: " + String.valueOf((Object)dataException)), (Throwable)dataException);
        }
        return dSPair;
    }

    static synchronized void removeLoader(com.elixirtech.report2.raw.model.CompositeChart compositeChart) {
        m_Loaders.remove(compositeChart);
    }

    private static class ChartLoader
    extends SwingWorker {
        private CompositeChartRenderer m_CompositeChartRenderer;
        private com.elixirtech.report2.raw.model.CompositeChart m_Chart;
        private RawReport m_Report;
        private Chunk m_Chunk;
        private Dimension m_Dimension;

        public ChartLoader(CompositeChartRenderer compositeChartRenderer, com.elixirtech.report2.raw.model.CompositeChart compositeChart, RawReport rawReport, Chunk chunk, Dimension dimension) {
            this.m_Chart = compositeChart;
            this.m_Report = rawReport;
            this.m_Chunk = chunk;
            this.m_Dimension = dimension;
            this.m_CompositeChartRenderer = compositeChartRenderer;
        }

        @Override
        public Object construct() {
            this.m_CompositeChartRenderer.loadImage(this.m_Report, this.m_Chunk.getSection(), this.m_Chart, this.m_Dimension);
            return null;
        }

        @Override
        public void finished() {
            super.finished();
            CompositeChartRenderer.removeLoader(this.m_Chart);
            Image image = this.m_Chart.getImage();
            if (image != null) {
                this.m_Chunk.repaint();
            }
        }
    }

    public static class DSPair {
        DataRecord[] rs;
        DataSchema ds;
    }
}

