/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.RecordExtractor;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.panel.MapView;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.util.StringUtil;

public class DesignerMapView
extends MapView {
    private RawReport m_Report;
    private MapElement m_Map;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DesignerMapView.class);

    public DesignerMapView(RawReport rawReport, MapElement mapElement, MapFile mapFile) {
        super(mapFile);
        this.m_Report = rawReport;
        this.m_Map = mapElement;
    }

    protected String getFillDataColumn() {
        return this.m_Map.getDataColumn();
    }

    protected int getDataPrimaryKeyIndex() {
        int n = -1;
        if (this.m_Table != null) {
            DataSchema dataSchema = this.m_Table.getSchema();
            n = dataSchema.getColumnIndex(this.m_Map.getDataKey());
        }
        return n;
    }

    protected IDataSource getDataSource() throws DataException {
        DataSource dataSource;
        String string = this.m_Map.getDataSource();
        String string2 = this.m_Map.getDataRange();
        if (StringUtil.notEmpty(string)) {
            dataSource = this.m_Report.getDataSource(string);
            string = dataSource != null ? dataSource.getDataSourceName() : null;
        }
        if (StringUtil.isEmpty(string)) {
            string = DesignerMapView.getDefaultDS(this.m_Report, this.m_Map.getChunk().getSection());
        }
        dataSource = (DataSourceManager)Elixir.get(DataSourceManager.class);
        IDataSource iDataSource = dataSource.getDataSource((DataSourceManager)dataSource, string);
        if ("Record".equals(string2)) {
            DataRecord dataRecord = null;
            try {
                dataRecord = RecordExtractor.getRecord((IDataSource)iDataSource, (int)0);
            }
            catch (DataException dataException) {
                m_Log.error((Object)("getFirstRecord: " + String.valueOf((Object)dataException)), (Throwable)dataException);
            }
            if (dataRecord != null) {
                return new DataTable("dummy", dataRecord.getSchema(), new DataRecord[]{dataRecord});
            }
            return new DataTable("dummy", iDataSource.getSchema(), new DataRecord[0]);
        }
        return iDataSource;
    }

    protected static String getDefaultDS(RawReport rawReport, Section section) {
        String string = section.getDataSource();
        if (StringUtil.notEmpty(string)) {
            DataSource dataSource = rawReport.getDataSource(string);
            return dataSource.getDataSourceName();
        }
        return "";
    }
}

