/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.graphics.GlyphOrientation;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.graphics.font.AWTFontMeasurerFactory;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.grid.GGrid;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Grid;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.CharUtil;
import java.awt.Dimension;
import java.awt.Rectangle;

public class GridRenderer
extends UiElementRenderer {
    public static final String TEXT_HEIGHT = "Text-Height";
    public static final String LINE_HEIGHT = "Line-Height";
    public static final String BOX_COUNT = "Box-Count";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GridRenderer.class);

    @Override
    protected void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        Grid grid = (Grid)rawElement;
        String string = grid.getLineGridProgression();
        Font font = new Font(grid.getFontName(), grid.isFontBold(), grid.isFontItalic(), grid.getFontSize());
        AWTFontMeasurerFactory aWTFontMeasurerFactory = new AWTFontMeasurerFactory();
        IFontMeasurer iFontMeasurer = aWTFontMeasurerFactory.getInstance(font);
        Rectangle rectangle = gRectangle.getChildRect();
        int n = (int)(iFontMeasurer.getAscent() + iFontMeasurer.getDescent());
        int n2 = (int)iFontMeasurer.getHeight();
        if (!TEXT_HEIGHT.equals(string)) {
            if (LINE_HEIGHT.equals(string)) {
                n = (int)iFontMeasurer.getHeight();
            } else if (string.startsWith(BOX_COUNT)) {
                int n3 = 1;
                String string2 = string.substring(BOX_COUNT.length()).trim();
                String[] stringArray = string2.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        n3 = Integer.parseInt(stringArray[0].trim());
                        if (n3 <= 0) {
                            m_Log.warn((Object)("Box-Count <=0 : " + n3));
                            n3 = 1;
                        }
                        n = rectangle.width / n3;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.warn((Object)("Bad Box-Count: " + string));
                    }
                }
                if (stringArray.length > 1) {
                    n3 = 1;
                    try {
                        n3 = Integer.parseInt(stringArray[1].trim());
                        if (n3 <= 0) {
                            m_Log.warn((Object)("Box-Count <=0 : " + n3));
                            n3 = 1;
                        }
                        n2 = rectangle.height / n3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.warn((Object)("Bad Box-Count: " + string));
                    }
                }
            } else {
                try {
                    n = Integer.parseInt(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.warn((Object)("Bad LineGridProgression: " + string));
                    n = (int)(iFontMeasurer.getAscent() + iFontMeasurer.getDescent());
                }
            }
        }
        GGrid gGrid = new GGrid();
        gGrid.setBoxSize(new Dimension(n, n2));
        gGrid.setConstructionColor(StandardColor.lookup("ERD-Construction-Line"));
        gGrid.setFont(Font.getAWTFont20(font), iFontMeasurer);
        gGrid.setFontColor(StandardColor.lookup(grid.getFontColor()));
        gGrid.setFontUnderline(grid.isFontUnderline());
        gGrid.setFontStrikethrough(grid.isFontStrikethrough());
        gGrid.setGlyphOrientation(GlyphOrientation.get(grid.getGlyphOrientation()));
        gGrid.setGridMode(grid.getLineGridMode().equals("Ideograph") ? 1 : 2);
        gGrid.setRectangle(rectangle);
        gGrid.setString(this.getData(grid));
        gGrid.setWritingMode(WritingMode.get(grid.getWritingMode()));
        gGrid.setCharacterOffset(grid.getCharacterOffsetX(), grid.getCharacterOffsetY());
        gGrid.setBoxDrawing(StandardColor.lookup(grid.getBoxBorderColor()), grid.isBoxBorderTop(), grid.isBoxBorderSide(), grid.isBoxBorderBottom(), grid.getBoxBorderHeight());
        gGrid.draw(renderContext.getGraphics());
    }

    protected String getData(Grid grid) {
        ControlSource controlSource = grid.getControlSource();
        String string = controlSource.getType();
        if ("Literal".equals(string)) {
            try {
                return CharUtil.decodeSlashU(controlSource.getText());
            }
            catch (Exception exception) {
                return controlSource.getText();
            }
        }
        return controlSource.getText();
    }
}

