/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.erd.UIConstants;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.graphics.Graphics2DWrapper;
import com.elixirtech.graphics.IGraphics2D;
import com.elixirtech.js.BasicScope;
import com.elixirtech.js.PrivilegedJavaProxy;
import com.elixirtech.js.ScriptException;
import com.elixirtech.js.ScriptManager;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingWorker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageRenderer
extends UiElementRenderer {
    private static Map<com.elixirtech.report2.raw.model.Image, String> m_Loaders = new HashMap<com.elixirtech.report2.raw.model.Image, String>();

    @Override
    public void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        boolean bl;
        Rectangle rectangle = gRectangle.getChildRect();
        com.elixirtech.report2.raw.model.Image image = (com.elixirtech.report2.raw.model.Image)rawElement;
        Image image2 = image.getImage();
        Script script = image.getScript();
        boolean bl2 = bl = !Script.isEmpty((Script)script);
        if (image2 == null && !image.isLoadError()) {
            ControlSource controlSource = image.getControlSource();
            String string = controlSource.getType();
            if ("URL".equals(string)) {
                ImageRenderer.loadAsync(image, renderContext.getChunk(), controlSource.getURL());
            }
            if ((image2 = image.getImage()) == null && bl) {
                image2 = this.createImage(image);
                try {
                    this.drawScriptedImage(image2, script);
                }
                catch (IOException iOException) {}
            }
        } else {
            Graphics2D graphics2D = renderContext.getGraphics();
            if (image2 != null) {
                Rectangle rectangle2 = new Rectangle(rectangle);
                int n = image2.getWidth(null);
                int n2 = image2.getHeight(null);
                if (bl) {
                    try {
                        this.drawScriptedImage(image2, script);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Dimension dimension = new Dimension(n * 20, n2 * 20);
                String string = image.getSizeMode();
                int n3 = Alignment.getAlignmentId((String)image.getHorizontalAlign(), (String)image.getVerticalAlign());
                if ("Clip".equals(string)) {
                    rectangle2 = Alignment.positionRect((Rectangle)rectangle2, (Dimension)dimension, (int)n3);
                    graphics2D.drawImage(image2, rectangle2.x, rectangle2.y, dimension.width, dimension.height, null);
                } else if ("Stretch".equals(string)) {
                    graphics2D.drawImage(image2, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 0, 0, n, n2, null);
                } else if ("Zoom".equals(string)) {
                    double d = (double)rectangle2.width / (double)dimension.width;
                    double d2 = (double)rectangle2.height / (double)dimension.height;
                    if (d >= d2) {
                        dimension.width = (int)(d2 * (double)dimension.width);
                        dimension.height = rectangle2.height;
                    } else {
                        dimension.width = rectangle2.width;
                        dimension.height = (int)(d * (double)dimension.height);
                    }
                    rectangle2 = Alignment.positionRect((Rectangle)rectangle2, (Dimension)dimension, (int)n3);
                    graphics2D.drawImage(image2, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 0, 0, n, n2, null);
                }
            } else {
                graphics2D.setColor(Color.BLACK);
                graphics2D.setStroke(UIConstants.THIN_LINE);
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics2D.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            }
        }
    }

    static synchronized void loadAsync(com.elixirtech.report2.raw.model.Image image, Chunk chunk, String string) {
        if (m_Loaders.get(image) == null) {
            m_Loaders.put(image, string);
            new ImageWorker(image, chunk).start();
        }
    }

    static synchronized void removeLoader(com.elixirtech.report2.raw.model.Image image) {
        m_Loaders.remove(image);
    }

    @Override
    protected boolean hasCurvedClip() {
        return true;
    }

    public static void loadImage(com.elixirtech.report2.raw.model.Image image) {
        Image image2 = image.getImage();
        ControlSource controlSource = image.getControlSource();
        String string = controlSource.getType();
        if ("URL".equals(string)) {
            IResourceProvider iResourceProvider = image.getResourceProvider();
            String string2 = controlSource.getURL();
            Image image3 = ImageLoader.getImage((IResourceProvider)iResourceProvider, (String)string2);
            if (image2 != null && image2 != image3) {
                image2.flush();
            }
            image.setImage(image3);
            image.setLoadError(image == null);
        } else {
            if (image2 != null) {
                image2.flush();
            }
            image.setImage(null);
            image.setLoadError(true);
        }
    }

    private Image createImage(com.elixirtech.report2.raw.model.Image image) {
        Color color = StandardColor.lookup(image.getBackgroundColor(), Color.WHITE);
        int n = (image.getWidth() - image.getPaddingTop() - image.getPaddingBottom() - image.getBorderWidth()) / 20;
        int n2 = (image.getHeight() - image.getPaddingLeft() - image.getPaddingRight() - image.getBorderWidth()) / 20;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(color2);
        graphics.dispose();
        image.setImage((Image)bufferedImage);
        return bufferedImage;
    }

    private void drawScriptedImage(Image image, Script script) throws IOException {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        int n = image.getHeight(null);
        int n2 = image.getWidth(null);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        IGraphics2D iGraphics2D = (IGraphics2D)PrivilegedJavaProxy.getProxy(IGraphics2D.class, (Object)new Graphics2DWrapper(graphics2D));
        Rectangle rectangle = new Rectangle(0, 0, n2, n);
        hashMap.put("g", iGraphics2D);
        hashMap.put("rc", rectangle);
        BasicScope basicScope = new BasicScope(hashMap);
        this.execute(basicScope, "ImagePaint", script.getText());
        graphics2D.dispose();
    }

    public Object execute(BasicScope basicScope, String string, String string2) {
        try {
            ArrayList<BasicScope> arrayList = new ArrayList<BasicScope>();
            arrayList.add(basicScope);
            ScriptManager scriptManager = new ScriptManager(string);
            return scriptManager.evaluate(arrayList, string, string2);
        }
        catch (ScriptException scriptException) {
            return null;
        }
    }

    private static class ImageWorker
    extends SwingWorker {
        private com.elixirtech.report2.raw.model.Image m_Image;
        private Chunk m_Chunk;

        public ImageWorker(com.elixirtech.report2.raw.model.Image image, Chunk chunk) {
            this.m_Image = image;
            this.m_Chunk = chunk;
        }

        @Override
        public Object construct() {
            ImageRenderer.loadImage(this.m_Image);
            return null;
        }

        @Override
        public void finished() {
            super.finished();
            ImageRenderer.removeLoader(this.m_Image);
            Image image = this.m_Image.getImage();
            if (image != null) {
                this.m_Chunk.repaint();
            }
        }
    }
}

