/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.erd.reportdesigner.renderer.DesignerMapView;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.sax.MapFileLoader;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;

public class MapRenderer
extends UiElementRenderer {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MapRenderer.class);

    @Override
    public void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        Rectangle rectangle = gRectangle.getChildRect();
        int n = rectangle.width / 20;
        int n2 = rectangle.height / 20;
        Graphics2D graphics2D = renderContext.getGraphics();
        MapElement mapElement = (MapElement)rawElement;
        Repository repository = (Repository)Elixir.get(Repository.class);
        FileObject fileObject = repository.getFileJ(mapElement.getMapFile());
        MapFile mapFile = null;
        if (fileObject != null) {
            try {
                mapFile = MapFileLoader.readMap((RMLFileObject)RepositoryConverter.toFO(fileObject));
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Unable to load mapfile \"" + mapElement.getMapFile() + "\": " + String.valueOf(iOException)), (Throwable)iOException);
                return;
            }
        }
        if (mapFile != null) {
            DesignerMapView designerMapView = new DesignerMapView(renderContext.getReport(), mapElement, mapFile);
            designerMapView.refresh();
            graphics2D.scale(20.0, 20.0);
            graphics2D.translate(rectangle.x / 20, rectangle.y / 20);
            designerMapView.paint(graphics2D, new Dimension(n, n2));
            graphics2D.translate(-rectangle.x / 20, -rectangle.y / 20);
            graphics2D.scale(0.05, 0.05);
        }
    }

    @Override
    protected boolean hasCurvedClip() {
        return true;
    }
}

