/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.RTF;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.rtf.RtfGraphicsWalker;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RTFRenderer
extends UiElementRenderer {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RTFRenderer.class);

    @Override
    protected void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        Object object;
        Object object2;
        Object object3;
        RTF rTF = (RTF)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        Graphics2D graphics2D = renderContext.getGraphics();
        ControlSource controlSource = rTF.getControlSource();
        try {
            object3 = rTF.getCachedRender();
            if (object3 instanceof RtfGroup) {
                Shape shape = graphics2D.getClip();
                graphics2D.clip(rectangle);
                graphics2D.scale(20.0, 20.0);
                Rectangle rectangle2 = new Rectangle(rectangle.x / 20, rectangle.y / 20, rectangle.width / 20, rectangle.height / 20);
                RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle2, graphics2D);
                ((RtfGroup)object3).walk(rtfGraphicsWalker);
                graphics2D.scale(0.05, 0.05);
                graphics2D.setClip(shape);
                return;
            }
            if (object3 == null) {
                Object object4;
                Object object5;
                object2 = controlSource.getType().intern();
                if ("Field" == object2) {
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(rectangle);
                    graphics2D.translate(rectangle.x, rectangle.y);
                    graphics2D.scale(20.0, 20.0);
                    Font font = new Font("SansSerif", 0, 12);
                    graphics2D.setFont(font);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString(controlSource.getDisplayNameValue(), 0, fontMetrics.getAscent());
                    graphics2D.scale(0.05, 0.05);
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                    graphics2D.setClip(shape);
                    return;
                }
                if ("Script" == object2) {
                    graphics2D.setColor(Color.black);
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(rectangle);
                    graphics2D.translate(rectangle.x, rectangle.y);
                    graphics2D.scale(20.0, 20.0);
                    ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                    ERDIcons.RTF.paintIcon(elixirFrame.getFrame(), graphics2D, 0, 0);
                    Font font = new Font("SansSerif", 0, 12);
                    graphics2D.setFont(font);
                    int n = ERDIcons.RTF.getIconWidth() + 5;
                    int n2 = 0;
                    graphics2D.drawString(I18N.ERD.getString("Rtf.ScriptedRTF"), n, n2 += graphics2D.getFontMetrics().getAscent());
                    graphics2D.scale(0.05, 0.05);
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                    graphics2D.setClip(shape);
                    return;
                }
                object = null;
                if ("URL" == object2) {
                    object = URLLoader.getInputStream((String)controlSource.getURL());
                } else {
                    object5 = controlSource.getText();
                    object4 = ((String)object5).getBytes("UTF-8");
                    object = new ByteArrayInputStream((byte[])object4);
                }
                if (object != null) {
                    object5 = new RtfReader((InputStream)object);
                    object4 = ((RtfReader)object5).getTreeRoot();
                    ((InputStream)object).close();
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(rectangle);
                    graphics2D.scale(20.0, 20.0);
                    Rectangle rectangle3 = new Rectangle(rectangle.x / 20, rectangle.y / 20, rectangle.width / 20, rectangle.height / 20);
                    RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle3, graphics2D);
                    ((RtfGroup)object4).walk(rtfGraphicsWalker);
                    rTF.setCachedRender(object4);
                    graphics2D.scale(0.05, 0.05);
                    graphics2D.setClip(shape);
                    return;
                }
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Can't renderDesign: " + String.valueOf(exception)), (Throwable)exception);
            rTF.setCachedRender((Object)exception);
        }
        object3 = controlSource.getDisplayNameValue();
        graphics2D.setColor(Color.black);
        object2 = graphics2D.getClip();
        graphics2D.clip(rectangle);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.scale(20.0, 20.0);
        object = new Font("SansSerif", 0, 12);
        graphics2D.setFont((Font)object);
        int n = 0;
        int n3 = 0;
        graphics2D.drawString("RTF: " + (String)object3, n, n3 += graphics2D.getFontMetrics().getAscent());
        graphics2D.scale(0.05, 0.05);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setClip((Shape)object2);
    }
}

