/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.graphics.GraphicsConstants;
import com.elixirtech.jdom.Document;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.SVG;
import com.elixirtech.svg.ElxSVGFactory;
import com.elixirtech.svg.SVGToImage;
import com.elixirtech.ui.SwingWorker;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.URLUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder;
import org.w3c.dom.svg.SVGDocument;

public class SVGRenderer
extends UiElementRenderer {
    private static Map<SVG, LoadInfo> m_Loaders = new HashMap<SVG, LoadInfo>();
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SVGRenderer.class);

    @Override
    protected void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        SVG sVG = (SVG)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        int n = rectangle.width / 20;
        int n2 = rectangle.height / 20;
        if (n > 0 && n2 > 0) {
            Graphics2D graphics2D = renderContext.getGraphics();
            if (sVG.isLoadError()) {
                Rectangle rectangle2 = rectangle;
                graphics2D.setColor(Color.BLACK);
                graphics2D.setStroke(GraphicsConstants.THIN_LINE);
                graphics2D.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                graphics2D.drawLine(rectangle2.x + rectangle2.width, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height);
            } else {
                Image image = sVG.getImage();
                if (image == null || image.getWidth(null) != n || image.getHeight(null) != n2) {
                    SVGRenderer.load(sVG, renderContext.getChunk(), n, n2);
                } else {
                    graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                }
            }
        }
    }

    @Override
    protected boolean hasCurvedClip() {
        return true;
    }

    static synchronized void load(SVG sVG, Chunk chunk, int n, int n2) {
        LoadInfo loadInfo = m_Loaders.get(sVG);
        if (loadInfo != null) {
            loadInfo.width = n;
            loadInfo.height = n2;
        } else {
            loadInfo = new LoadInfo(n, n2);
            m_Loaders.put(sVG, loadInfo);
            new SVGLoader(sVG, chunk, loadInfo).start();
        }
    }

    static synchronized void removeLoader(SVG sVG) {
        m_Loaders.remove(sVG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SVGDocument buildSVGContent(SVG sVG) {
        Object object;
        Document document = sVG.getDocument();
        if (document != null) {
            try {
                return ElxSVGFactory.buildFromJDOM((Document)document);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Unable to convert JDOM to SVGDocument: " + String.valueOf(exception)), (Throwable)exception);
                return null;
            }
        }
        String string = sVG.getLocation();
        if (string == null) {
            m_Log.error((Object)"No SVG Location found");
            return null;
        }
        if ((string = string.trim()).startsWith("=")) {
            object = RenderStack.current().getScriptEngine();
            string = String.valueOf(object.evaluate(string));
        }
        if (string.endsWith(".wmf")) {
            object = null;
            try {
                object = SVGRenderer.getInputStream(string);
                TranscoderInput transcoderInput = new TranscoderInput((InputStream)object);
                TranscoderOutput transcoderOutput = new TranscoderOutput();
                WMFTranscoder wMFTranscoder = new WMFTranscoder();
                wMFTranscoder.transcode(transcoderInput, transcoderOutput);
                SVGDocument sVGDocument = (SVGDocument)transcoderOutput.getDocument();
                return sVGDocument;
            }
            catch (Exception exception) {
                m_Log.error((Object)("Error reading WMF: " + String.valueOf(exception)), (Throwable)exception);
                SVGDocument sVGDocument = null;
                return sVGDocument;
            }
            finally {
                FileUtil.close((Closeable)object);
            }
        }
        try {
            return ElxSVGFactory.buildFromURI((String)string);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error reading SVG (" + string + "): " + String.valueOf(exception)), (Throwable)exception);
            return null;
        }
    }

    private static InputStream getInputStream(String string) throws IOException {
        if (URLUtil.isURL(string)) {
            return URLLoader.getInputStream((String)string);
        }
        FileObject fileObject = RepositoryConverter.toFO(RenderStack.current().getFile(string));
        if (fileObject != null) {
            return fileObject.getInputStream();
        }
        m_Log.error((Object)("Location not found: " + string));
        return null;
    }

    private static class LoadInfo {
        public int width;
        public int height;

        public LoadInfo(int n, int n2) {
            this.width = n;
            this.height = n2;
        }
    }

    private static class SVGLoader
    extends SwingWorker {
        private SVG m_SVG;
        private Chunk m_Chunk;
        private LoadInfo m_Info;

        public SVGLoader(SVG sVG, Chunk chunk, LoadInfo loadInfo) {
            this.m_SVG = sVG;
            this.m_Chunk = chunk;
            this.m_Info = loadInfo;
        }

        @Override
        public Object construct() {
            SVGDocument sVGDocument = SVGRenderer.buildSVGContent(this.m_SVG);
            if (sVGDocument != null) {
                BufferedImage bufferedImage = SVGToImage.convert((SVGDocument)sVGDocument, (Dimension)new Dimension(this.m_Info.width, this.m_Info.height));
                if (bufferedImage != null) {
                    this.m_SVG.setImage((Image)bufferedImage);
                } else {
                    this.m_SVG.setLoadError(true);
                }
            } else {
                this.m_SVG.setLoadError(true);
            }
            return null;
        }

        @Override
        public void finished() {
            super.finished();
            SVGRenderer.removeLoader(this.m_SVG);
            Image image = this.m_SVG.getImage();
            if (image != null) {
                this.m_Chunk.repaint();
            }
        }
    }
}

