/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.erd.UIConstants;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.renderer.UiElementRenderer;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.VerticalAlignment;
import com.elixirtech.graphics.text.TextBuilder;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.TextElement;
import com.elixirtech.report2.raw.property.LineHeight;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Line2D;
import java.text.AttributedString;
import java.util.HashMap;

public abstract class TextElementRenderer
extends UiElementRenderer {
    public abstract String getText(TextElement var1);

    @Override
    public void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
        int n;
        TextElement textElement = (TextElement)rawElement;
        Rectangle rectangle = gRectangle.getChildRect();
        Object object = this.getText(textElement);
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, textElement.getFontName());
        hashMap.put(TextAttribute.SIZE, Float.valueOf((float)textElement.getFontSize() / 20.0f));
        hashMap.put(TextAttribute.WEIGHT, textElement.isFontBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        hashMap.put(TextAttribute.POSTURE, textElement.isFontItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        Font font = new Font(hashMap);
        TextAlignment textAlignment = TextAlignment.get(textElement.getTextAlign());
        VerticalAlignment verticalAlignment = VerticalAlignment.get(textElement.getVerticalAlign());
        Graphics2D graphics2D = renderContext.getGraphics();
        graphics2D.translate(rectangle.x, rectangle.y);
        object = (String)object + "\n";
        String[] stringArray = ((String)object).split("\n");
        float f = 0.0f;
        float f2 = rectangle.width;
        float f3 = rectangle.height;
        int n2 = ((Field)textElement).getOrientation();
        n2 = this.normalizeOrientation(n2);
        if (n2 == 90) {
            f2 = rectangle.height;
            f3 = rectangle.width;
            graphics2D.translate(rectangle.width, 0);
            graphics2D.rotate(1.5707963267948966);
        } else if (n2 == 180) {
            graphics2D.translate(rectangle.width, rectangle.height);
            graphics2D.rotate(Math.PI);
        } else if (n2 == 270) {
            f2 = rectangle.height;
            f3 = rectangle.width;
            graphics2D.translate(0, rectangle.height);
            graphics2D.rotate(-1.5707963267948966);
        }
        graphics2D.scale(20.0, 20.0);
        TextBuilder[] textBuilderArray = new TextBuilder[stringArray.length];
        float f4 = 0.0f;
        LineHeight lineHeight = LineHeight.NORMAL;
        if (textElement instanceof Field) {
            lineHeight = ((Field)textElement).getLineHeightValue();
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Color color = StandardColor.lookup("ERD-Construction-Line");
        for (n = 0; n < stringArray.length; ++n) {
            textBuilderArray[n] = new TextBuilder();
            textBuilderArray[n].setCanGrow(false);
            textBuilderArray[n].setConstructionColor(color);
            textBuilderArray[n].setDimension(f2 / 20.0f, f3 / 20.0f);
            textBuilderArray[n].setFirstLineIndent((float)textElement.getFirstLineIndent() / 20.0f);
            textBuilderArray[n].setAlignment(textAlignment);
            if (stringArray[n].length() == 0) {
                stringArray[n] = " ";
            }
            LineMetrics lineMetrics = font.getLineMetrics(stringArray[n], fontRenderContext);
            float f5 = lineHeight.getValue(lineMetrics.getHeight() * 20.0f);
            textBuilderArray[n].setLineHeight(f5);
            AttributedString attributedString = new AttributedString(stringArray[n]);
            attributedString.addAttribute(TextAttribute.FONT, font);
            if (textElement.isFontUnderline()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (textElement.isFontStrikethrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            attributedString.addAttribute(TextAttribute.FOREGROUND, StandardColor.lookup(textElement.getFontColor()));
            textBuilderArray[n].setText(attributedString);
            textBuilderArray[n].buildLayouts(fontRenderContext, 0);
            f4 += textBuilderArray[n].getActualHeight();
        }
        if (verticalAlignment == VerticalAlignment.CENTER) {
            f += (f3 / 20.0f - f4) / 2.0f;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            f += f3 / 20.0f - f4;
        }
        for (n = 0; n < stringArray.length; ++n) {
            textBuilderArray[n].render(graphics2D, 0.0f, f, 0, true);
            float f6 = textBuilderArray[n].getActualHeight();
            f += f6;
            f3 -= f6;
        }
        if (f3 > 0.0f) {
            graphics2D.setStroke(UIConstants.THINNEST_LINE);
            graphics2D.setColor(color);
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            float f7 = lineHeight.getValue(lineMetrics.getHeight() * 20.0f) / 20.0f;
            f += lineMetrics.getAscent();
            f3 -= lineMetrics.getAscent();
            if (f7 > 0.0f) {
                while (f3 > 0.0f) {
                    Line2D.Float float_ = new Line2D.Float(0.0f, f, f2, f);
                    graphics2D.draw(float_);
                    f += f7;
                    f3 -= f7;
                }
            }
        }
        graphics2D.scale(0.05, 0.05);
        if (n2 == 90) {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-rectangle.width, 0);
        } else if (n2 == 180) {
            graphics2D.rotate(-Math.PI);
            graphics2D.translate(-rectangle.width, -rectangle.height);
        } else if (n2 == 270) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -rectangle.height);
        }
        graphics2D.translate(-rectangle.x, -rectangle.y);
    }

    private int normalizeOrientation(int n) {
        while (n < 0) {
            n += 360;
        }
        while (n >= 360) {
            n -= 360;
        }
        if (n < 90) {
            return 0;
        }
        if (n < 180) {
            return 90;
        }
        if (n < 270) {
            return 180;
        }
        return 270;
    }
}

