/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.renderer;

import com.elixirtech.erd.reportdesigner.UiRenderer;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public abstract class UiElementRenderer
extends UiRenderer {
    @Override
    public void draw(RenderContext renderContext, RawElement rawElement) {
        GRectangle gRectangle = this.getGRectangle(rawElement);
        Graphics2D graphics2D = renderContext.getGraphics();
        gRectangle.draw(graphics2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(gRectangle.getChildClipShape());
        this.drawContent(renderContext, rawElement, gRectangle);
        graphics2D.setClip(shape);
    }

    protected void drawContent(RenderContext renderContext, RawElement rawElement, GRectangle gRectangle) {
    }

    protected GRectangle getGRectangle(RawElement rawElement) {
        int n;
        int n2;
        int n3;
        GRectangle gRectangle = new GRectangle(this.getRect(rawElement));
        gRectangle.setPadding(rawElement.getPaddingLeft(), rawElement.getPaddingTop(), rawElement.getPaddingRight(), rawElement.getPaddingBottom());
        gRectangle.setBackground(StandardColor.lookup(rawElement.getBackgroundColor()));
        BorderStyle borderStyle = BorderStyle.get(rawElement.getBorderStyle());
        if (borderStyle != BorderStyle.NONE) {
            Color color = StandardColor.lookup(rawElement.getBorderColor());
            n3 = rawElement.getBorderWidth();
            n2 = this.getSides(rawElement);
            gRectangle.setBorder(borderStyle, n3, color, n2);
        }
        if ((n = rawElement.getBorderRadius()) > 0) {
            n3 = rawElement.getWidth() / 2;
            int n4 = Math.min(n3, n2 = rawElement.getHeight() / 2);
            if (n > n4) {
                n = n4;
            }
            gRectangle.setBorderRadius(n, n);
        }
        gRectangle.setCurvedClip(this.hasCurvedClip());
        gRectangle.setPaddedClip(this.hasPaddedClip());
        return gRectangle;
    }

    protected boolean isTrue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    protected Rectangle getRect(RawElement rawElement) {
        return new Rectangle(rawElement.getLeft(), rawElement.getTop(), rawElement.getWidth(), rawElement.getHeight());
    }

    protected int getSides(RawElement rawElement) {
        int n = 0;
        if (rawElement.isBorderLeft()) {
            n |= 1;
        }
        if (rawElement.isBorderTop()) {
            n |= 2;
        }
        if (rawElement.isBorderRight()) {
            n |= 4;
        }
        if (rawElement.isBorderBottom()) {
            n |= 8;
        }
        return n;
    }

    protected boolean hasPaddedClip() {
        return false;
    }

    protected boolean hasCurvedClip() {
        return false;
    }
}

