/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.report;

import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.EditableTable;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.BooleanUtil;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ParametersPanel
extends JPanel
implements ActionListener,
CurrentTab {
    RawReport m_Report;
    private EditableTable m_Table;
    private ParameterModel m_Model;
    static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Value", "TableModel.Enabled"};

    public ParametersPanel(RawReport rawReport) {
        this.m_Report = rawReport;
        this.setLayout(new BorderLayout());
        this.m_Model = new ParameterModel(COLUMNS);
        this.m_Table = new OrderedEditableTable(this.m_Model, false);
        this.m_Table.addActionListener(this);
        this.m_Table.setBorder(new TitledBorder(new JLabel(I18N.ERD.getString("ParametersPanel.parameters-label"))));
        this.m_Table.setAutoResizeMode(1);
        this.m_Table.setAutoCreateColumns(false);
        TableColumnModel tableColumnModel = this.m_Table.getTable().getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        TableUtil.setColumnWidth(this.m_Table.getTable(), tableColumn, I18N.ERD, COLUMNS[2], 40);
        this.add(this.m_Table);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void setCurrent(boolean bl) {
        if (bl) {
            this.m_Model.fireTableDataChanged();
        } else {
            this.m_Table.disposeEditor();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            Parameter parameter = new Parameter();
            parameter.setEnabled(Boolean.TRUE);
            this.m_Model.addParameter(parameter);
            this.m_Table.select(this.m_Model.getRowCount() - 1);
            this.m_Report.setDirty(true);
        } else if ("minus".equals(string)) {
            int n;
            int[] nArray = this.m_Table.getSelectedRows();
            Parameter[] parameterArray = new Parameter[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                parameterArray[n] = this.m_Model.getParameter(nArray[n]);
            }
            for (n = 0; n < parameterArray.length; ++n) {
                this.m_Model.removeParameter(parameterArray[n]);
            }
            this.m_Report.setDirty(true);
        } else if ("copy".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            Holder holder = new Holder();
            for (int i = 0; i < nArray.length; ++i) {
                holder.addContent((Object)this.m_Report.getParameter(nArray[i]));
            }
            ClipboardUtil.setHolder(holder);
        } else if ("paste".equals(string)) {
            Holder holder = ClipboardUtil.getHolder();
            Iterator iterator = holder.getContentIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Parameter)) continue;
                this.m_Model.addParameter((Parameter)e);
                this.m_Report.setDirty(true);
            }
        } else if ("up".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            this.m_Model.moveUp(nArray[0]);
            this.m_Table.select(nArray[0] - 1);
            this.m_Report.setDirty(true);
        } else if ("down".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            this.m_Model.moveDown(nArray[0]);
            this.m_Table.select(nArray[0] + 1);
            this.m_Report.setDirty(true);
        }
    }

    private class ParameterModel
    extends ElxTableModel {
        public ParameterModel(String[] stringArray) {
            super(I18N.ERD, stringArray);
        }

        @Override
        public int getRowCount() {
            return ParametersPanel.this.m_Report.getParameterCount();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Parameter parameter = ParametersPanel.this.m_Report.getParameter(n);
            if (n2 == 0) {
                return parameter.getKey();
            }
            if (n2 == 1) {
                return parameter.getValue();
            }
            return BooleanUtil.value(parameter.isEnabled()) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Parameter parameter = ParametersPanel.this.m_Report.getParameter(n);
            if (n2 == 0) {
                parameter.setKey(object.toString());
            } else if (n2 == 1) {
                parameter.setValue(object.toString());
            } else {
                Boolean bl = (Boolean)object;
                parameter.setEnabled(bl);
                boolean bl2 = this.checkDuplicateEnables(parameter);
                if (bl2 |= this.checkGroupings(n, parameter)) {
                    this.fireTableStructureChanged();
                }
            }
            ParametersPanel.this.m_Report.setDirty(true);
        }

        public Parameter getParameter(int n) {
            return ParametersPanel.this.m_Report.getParameter(n);
        }

        public void addParameter(Parameter parameter) {
            int n = ParametersPanel.this.m_Report.getParameterCount();
            ParametersPanel.this.m_Report.addParameter(parameter);
            this.fireTableRowsInserted(n, n);
            if (this.checkDuplicateEnables(parameter)) {
                this.fireTableStructureChanged();
            }
        }

        public void removeParameter(Parameter parameter) {
            ParametersPanel.this.m_Report.removeParameter(parameter);
            int n = ParametersPanel.this.m_Report.getParameterCount();
            this.fireTableRowsDeleted(n, n);
        }

        public void moveUp(int n) {
            List list = ParametersPanel.this.m_Report.getParameterList();
            Parameter parameter = (Parameter)list.remove(n);
            list.add(n - 1, parameter);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveDown(int n) {
            List list = ParametersPanel.this.m_Report.getParameterList();
            Parameter parameter = (Parameter)list.remove(n);
            list.add(n + 1, parameter);
            this.fireTableRowsUpdated(n, n + 1);
        }

        private boolean checkDuplicateEnables(Parameter parameter) {
            String string = parameter.getKey();
            boolean bl = false;
            int n = ParametersPanel.this.m_Report.getParameterCount();
            for (int i = 0; i < n; ++i) {
                Parameter parameter2 = ParametersPanel.this.m_Report.getParameter(i);
                if (parameter2 == parameter || parameter2 == null || !parameter2.getKey().equals(string)) continue;
                parameter2.setEnabled(Boolean.FALSE);
                bl = true;
            }
            return bl;
        }

        private boolean checkGroupings(int n, Parameter parameter) {
            boolean bl = false;
            String string = parameter.getKey();
            if ("<GROUP>".equalsIgnoreCase(string) && BooleanUtil.value(parameter.isEnabled())) {
                Parameter parameter2;
                int n2 = ParametersPanel.this.m_Report.getParameterCount();
                for (int i = n + 1; i < n2 && !"<GROUP>".equalsIgnoreCase((parameter2 = ParametersPanel.this.m_Report.getParameter(i)).getKey()); ++i) {
                    parameter2.setEnabled(Boolean.TRUE);
                    bl = true;
                    this.checkDuplicateEnables(parameter2);
                }
            }
            return bl;
        }
    }
}

