/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.report;

import com.elixirtech.erd.reportdesigner.report.ParametersPanel;
import com.elixirtech.erd.reportdesigner.report.ReportTreeModel;
import com.elixirtech.erd.reportdesigner.report.SectionInvocationPanel;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.ElxSplitPane;
import com.elixirtech.ui.tree.TreeSupport;
import com.elixirtech.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class ReportPanel
extends JPanel
implements CurrentTab {
    private RawReport m_Report;
    private JTree m_Tree;
    private ReportTreeModel m_TreeModel;
    private ParametersPanel m_ParametersPanel;
    private SectionInvocationPanel m_SeqInvPanel;

    public ReportPanel(RawReport rawReport) {
        this.m_Report = rawReport;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JComponent jComponent = this.buildLeft();
        JComponent jComponent2 = this.buildRight();
        ElxSplitPane elxSplitPane = new ElxSplitPane(1, jComponent, jComponent2);
        elxSplitPane.setDividerLocation(150);
        this.add(elxSplitPane);
    }

    @Override
    public void setCurrent(boolean bl) {
        this.m_ParametersPanel.setCurrent(bl);
        if (bl) {
            boolean bl2 = this.m_Report.getSecurity().isReadOnly();
            this.m_SeqInvPanel.setEnabled(!bl2);
            this.m_ParametersPanel.setEnabled(!bl2);
        }
    }

    public ReportTreeModel getReportTreeModel() {
        return this.m_TreeModel;
    }

    protected JComponent buildLeft() {
        this.m_TreeModel = new ReportTreeModel(this.m_Report);
        this.m_Tree = new JTree(this.m_TreeModel);
        this.m_Tree.getSelectionModel().setSelectionMode(1);
        this.m_TreeModel.setTree(this.m_Tree);
        this.m_Tree.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        new TreeSupport(this.m_Tree, false);
        TreeUtil.expandTree(this.m_Tree);
        TreeUtil.preventRootCollapse(this.m_Tree);
        JScrollPane jScrollPane = new JScrollPane(this.m_Tree);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    protected JComponent buildRight() {
        this.m_SeqInvPanel = new SectionInvocationPanel(this.m_Report);
        this.m_ParametersPanel = new ParametersPanel(this.m_Report);
        ElxSplitPane elxSplitPane = new ElxSplitPane(0, this.m_SeqInvPanel, this.m_ParametersPanel);
        elxSplitPane.setMinimumSize(new Dimension(100, 100));
        return elxSplitPane;
    }
}

