/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.reportdesigner.pagesetup.PageSetupPage;
import com.elixirtech.erd.reportdesigner.report.ReportTreeModel;
import com.elixirtech.erd.reportdesigner.section.SectionWizard;
import com.elixirtech.erd.reportdesigner.style.ChooseStylesheetPage;
import com.elixirtech.erd.reportdesigner.style.StylePage;
import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StylesheetRef;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.report.ReportPropertiesWizard;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class ReportTreeActions {

    public static class Delete
    extends ReportTreeAction {
        private Object m_Object;

        public Delete(ReportTreeModel reportTreeModel, Object object) {
            super(reportTreeModel, "ReportTree.Delete");
            this.setEnabled(!reportTreeModel.isReadOnly());
            this.m_Object = object;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RawReport rawReport = this.m_Model.getReport();
            if (this.m_Object instanceof DataSource) {
                rawReport.removeDataSource((DataSource)this.m_Object);
                rawReport.setDirty(true);
            } else if (this.m_Object instanceof PageSetup) {
                rawReport.removePageSetup((PageSetup)this.m_Object);
                rawReport.setDirty(true);
            } else if (this.m_Object instanceof Section) {
                rawReport.removeSection((Section)this.m_Object);
                rawReport.setDirty(true);
            } else if (this.m_Object instanceof Style) {
                rawReport.removeStyle((Style)this.m_Object);
                rawReport.setDirty(true);
            }
        }
    }

    public static class Paste
    extends ReportTreeAction {
        public Paste(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.Paste");
            this.setEnabled(!reportTreeModel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RawReport rawReport = this.m_Model.getReport();
            Holder holder = ClipboardUtil.getHolder(false);
            Iterator iterator = holder.getContentIterator();
            while (iterator.hasNext()) {
                DataSource dataSource;
                Object e = iterator.next();
                if (e instanceof DataSource) {
                    dataSource = (DataSource)e;
                    this.m_Model.findFreeName(dataSource);
                    rawReport.addDataSource(dataSource);
                    rawReport.setDirty(true);
                    continue;
                }
                if (e instanceof PageSetup) {
                    dataSource = (PageSetup)e;
                    this.m_Model.findFreeName((PageSetup)dataSource);
                    rawReport.addPageSetup((PageSetup)dataSource);
                    rawReport.setDirty(true);
                    continue;
                }
                if (e instanceof Section) {
                    dataSource = (Section)e;
                    this.m_Model.findFreeName((Section)dataSource);
                    rawReport.addSection((Section)dataSource);
                    rawReport.setDirty(true);
                    continue;
                }
                if (!(e instanceof Style)) continue;
                dataSource = (Style)e;
                this.m_Model.findFreeName((Style)dataSource);
                rawReport.addStyle((Style)dataSource);
                rawReport.setDirty(true);
            }
            holder.loaded();
        }
    }

    public static class Copy
    extends ReportTreeAction {
        private Object m_Object;

        public Copy(ReportTreeModel reportTreeModel, Object object) {
            super(reportTreeModel, "ReportTree.Copy");
            this.m_Object = object;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Holder holder = new Holder();
            holder.addContent(this.m_Object);
            ClipboardUtil.setHolder(holder);
        }
    }

    public static class EditStylesheet
    extends ReportTreeAction {
        private StylesheetRef m_Stylesheet;

        public EditStylesheet(ReportTreeModel reportTreeModel, StylesheetRef stylesheetRef) {
            super(reportTreeModel, "ReportTree.EditStylesheet");
            this.m_Stylesheet = stylesheetRef;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            FileObject fileObject = RepositoryConverter.toFO(this.m_Model.getReport().getFile(this.m_Stylesheet.getName()));
            if (fileObject != null) {
                iViewModel.openFile(fileObject);
            } else {
                ElixirJ.error(I18N.ERD.getString("ReportTreeActions.error-stylesheet") + this.m_Stylesheet.getName() + I18N.ERD.getString("ReportTreeActions.error-not-found"));
            }
        }
    }

    public static class EditStyle
    extends ReportTreeAction {
        private Style m_Style;

        public EditStyle(ReportTreeModel reportTreeModel, Style style) {
            super(reportTreeModel, "ReportTree.EditStyle");
            this.m_Style = style;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            IWizard iWizard = StylePage.getWizard(this.m_Model.getReport(), this.m_Style);
            elixirFrame.showWizard(iWizard);
            if (iWizard.isFinished()) {
                this.m_Model.fireTreeNodeChanged(this.m_Style);
            }
        }
    }

    public static class AddStylesheet
    extends ReportTreeAction {
        public AddStylesheet(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.AddStylesheet");
            this.setEnabled(!reportTreeModel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RawReport rawReport = this.m_Model.getReport();
            IWizard iWizard = ChooseStylesheetPage.getOnePageWizard(rawReport);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(iWizard);
        }
    }

    public static class AddStyle
    extends ReportTreeAction {
        public AddStyle(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.AddStyle");
            this.setEnabled(!reportTreeModel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Style style = new Style();
            RawReport rawReport = this.m_Model.getReport();
            style.setName(ReportUtil.getNextStyleName(rawReport));
            IWizard iWizard = StylePage.getWizard(rawReport, style);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(iWizard);
            if (iWizard.isFinished()) {
                this.m_Model.fireTreeNodeChanged(style);
            }
        }
    }

    public static class EditSection
    extends ReportTreeAction {
        private Section m_Section;

        public EditSection(ReportTreeModel reportTreeModel, Section section) {
            super(reportTreeModel, "ReportTree.EditSection");
            this.m_Section = section;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            SectionWizard sectionWizard = new SectionWizard(this.m_Model.getReport(), this.m_Section);
            elixirFrame.showWizard(sectionWizard);
            if (sectionWizard.isFinished()) {
                this.m_Model.fireTreeNodeChanged(this.m_Section);
            }
        }
    }

    public static class AddSection
    extends ReportTreeAction {
        public AddSection(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.AddSection");
            this.setEnabled(!reportTreeModel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Section section = new Section();
            RawReport rawReport = this.m_Model.getReport();
            section.setName(ReportUtil.getNextSectionName(rawReport));
            SectionWizard sectionWizard = new SectionWizard(rawReport, section);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(sectionWizard);
        }
    }

    public static class EditPageSetup
    extends ReportTreeAction {
        private PageSetup m_PageSetup;

        public EditPageSetup(ReportTreeModel reportTreeModel, PageSetup pageSetup) {
            super(reportTreeModel, "ReportTree.EditPageSetup");
            this.m_PageSetup = pageSetup;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            RawReport rawReport = this.m_Model.getReport();
            IWizard iWizard = PageSetupPage.getWizard(rawReport, this.m_PageSetup);
            elixirFrame.showWizard(iWizard);
            if (iWizard.isFinished()) {
                this.m_Model.fireTreeNodeChanged(this.m_PageSetup);
            }
        }
    }

    public static class AddPageSetup
    extends ReportTreeAction {
        public AddPageSetup(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.AddPageSetup");
            this.setEnabled(!reportTreeModel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RawReport rawReport = this.m_Model.getReport();
            PageSetup pageSetup = new PageSetup();
            pageSetup.setName(ReportUtil.getNextPageSetupName(rawReport));
            pageSetup.setPaper("iso-a4");
            pageSetup.setWidth(11905);
            pageSetup.setHeight(16837);
            pageSetup.setOrientation("Portrait");
            pageSetup.setHorizontalPageCount(1);
            pageSetup.setTop(1440);
            pageSetup.setLeft(1440);
            pageSetup.setBottom(1440);
            pageSetup.setRight(1440);
            pageSetup.setColumnCount(1);
            pageSetup.setColumnSpacing(0);
            pageSetup.setRowSpacing(0);
            pageSetup.setColumnLayout("Down Then Across");
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            try {
                IWizard iWizard = PageSetupPage.getWizard(rawReport, pageSetup);
                elixirFrame.showWizard(iWizard);
                if (iWizard.isFinished()) {
                    rawReport.addPageSetup(pageSetup);
                }
            }
            catch (Exception exception) {
                ElixirJ.error(I18N.ERD.getString("ReportTreeActions.error-unable-setup") + String.valueOf(exception), exception);
            }
        }
    }

    public static class OpenDataSource
    extends ReportTreeAction {
        private DataSource m_DataSource;

        public OpenDataSource(ReportTreeModel reportTreeModel, DataSource dataSource) {
            super(reportTreeModel, "ReportTree.OpenDataSource");
            this.m_DataSource = dataSource;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Repository repository = (Repository)Elixir.get(Repository.class);
            FileObject fileObject = repository.getFileJ(this.m_DataSource.getDataSourceName());
            if (fileObject != null) {
                IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                iViewModel.openFile(fileObject);
            } else {
                ElixirJ.error(OpenDataSource.getString(I18N.ERD, "ReportTree.OpenDataSourceError"));
            }
        }
    }

    public static class EditDataSource
    extends ReportTreeAction {
        private DataSource m_DataSource;

        public EditDataSource(ReportTreeModel reportTreeModel, DataSource dataSource) {
            super(reportTreeModel, "ReportTree.EditDataSource");
            this.m_DataSource = dataSource;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_Model.getReport(), this.m_DataSource);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(addDataSourceWizard);
            if (addDataSourceWizard.isFinished()) {
                this.m_Model.fireTreeNodeChanged(this.m_DataSource);
            }
        }
    }

    public static class AddDataSource
    extends ReportTreeAction {
        public AddDataSource(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.AddDataSource");
            this.setEnabled(!reportTreeModel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RawReport rawReport = this.m_Model.getReport();
            DataSource dataSource = new DataSource();
            dataSource.setName(ReportUtil.getNextDataSourceName(rawReport));
            AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(rawReport, dataSource);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(addDataSourceWizard);
        }
    }

    public static class EditReport
    extends ReportTreeAction {
        public EditReport(ReportTreeModel reportTreeModel) {
            super(reportTreeModel, "ReportTree.EditReport");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportPropertiesWizard reportPropertiesWizard = new ReportPropertiesWizard(this.m_Model.getReport());
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(reportPropertiesWizard);
            if (reportPropertiesWizard.isFinished()) {
                this.m_Model.fireTreeNodeChanged(this.m_Model.getReport());
                IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                IPanelView iPanelView = iViewModel.getCurrentView();
                iPanelView.setCurrent(true);
            }
        }
    }

    private static abstract class ReportTreeAction
    extends ERDAction {
        protected ReportTreeModel m_Model;

        protected ReportTreeAction(ReportTreeModel reportTreeModel, String string) {
            super(string);
            this.m_Model = reportTreeModel;
        }
    }
}

