/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirAction;
import com.elixirtech.erd.images.Icons;
import com.elixirtech.erd.reportdesigner.report.ReportTreeActions;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.i18n.Name;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StylesheetRef;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.tree.TreeModelEx;
import com.elixirtech.ui.tree.TreeUtil;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.Repository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ReportTreeModel
implements TreeModelEx,
ChangeListener {
    private static final String[] TREE_BRANCHES = new String[]{"ReportTree.DataSources", "ReportTree.PageSetup", "ReportTree.Sections", "ReportTree.Styles"};
    private Repository m_Repository;
    private RawReport m_Report;
    private JTree m_Tree;
    private List<WrapperNode> m_Wrappers = new ArrayList<WrapperNode>();
    private List<TreeModelListener> m_Listeners = new ArrayList<TreeModelListener>();

    public ReportTreeModel(RawReport rawReport) {
        this.m_Report = rawReport;
        this.m_Repository = (Repository)Elixir.get(Repository.class);
        Name[] nameArray = I18NUtil.getNames(I18N.ERD, TREE_BRANCHES);
        this.m_Wrappers.add(new WrapperNode(nameArray[0], this.m_Report.getDataSourceList()));
        this.m_Wrappers.add(new WrapperNode(nameArray[1], this.m_Report.getPageSetupList()));
        this.m_Wrappers.add(new WrapperNode(nameArray[2], this.m_Report.getSectionList()));
        this.m_Wrappers.add(new WrapperNode(nameArray[3], this.m_Report.getStyleMap()));
        this.m_Report.addChangeListener((ChangeListener)this);
    }

    public boolean isReadOnly() {
        return this.m_Report.getSecurity().isReadOnly();
    }

    public void setTree(JTree jTree) {
        this.m_Tree = jTree;
    }

    @Override
    public Icon getIcon(Object object) {
        if (object == this.m_Report) {
            return Icons.TEMPLATE;
        }
        if (object instanceof WrapperNode) {
            return StandardIcons.FOLDER;
        }
        if (object instanceof DataSource) {
            if (this.hasError((DataSource)object)) {
                return StandardIcons.error(Icons.DATASOURCE);
            }
            return Icons.DATASOURCE;
        }
        if (object instanceof PageSetup) {
            return Icons.PAGE_SETUP;
        }
        if (object instanceof Section) {
            if (this.hasError((Section)object)) {
                return StandardIcons.error(Icons.SECTION);
            }
            return Icons.SECTION;
        }
        if (object instanceof Style) {
            return Icons.STYLE;
        }
        return null;
    }

    @Override
    public String getLabel(Object object) {
        if (object == this.m_Report) {
            return this.m_Report.getName();
        }
        if (object instanceof WrapperNode) {
            return ((WrapperNode)object).getName().getLabel();
        }
        return String.valueOf(object);
    }

    @Override
    public void setLabel(Object object, String string) {
    }

    @Override
    public JPopupMenu getPopupMenu(Object object) {
        if (object == this.m_Report) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new ReportTreeActions.EditReport(this));
            jPopupMenu.add(new ReportTreeActions.Paste(this));
            return jPopupMenu;
        }
        if (object instanceof WrapperNode) {
            WrapperNode wrapperNode = (WrapperNode)object;
            String string = wrapperNode.getName().getName();
            if (TREE_BRANCHES[0].equals(string)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.AddDataSource(this));
                jPopupMenu.add(new ReportTreeActions.Paste(this));
                return jPopupMenu;
            }
            if (TREE_BRANCHES[1].equals(string)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.AddPageSetup(this));
                jPopupMenu.add(new ReportTreeActions.Paste(this));
                return jPopupMenu;
            }
            if (TREE_BRANCHES[2].equals(string)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.AddSection(this));
                jPopupMenu.add(new ReportTreeActions.Paste(this));
                return jPopupMenu;
            }
            if (TREE_BRANCHES[3].equals(string)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.AddStyle(this));
                jPopupMenu.add(new ReportTreeActions.Paste(this));
                return jPopupMenu;
            }
        } else {
            if (object instanceof DataSource) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.EditDataSource(this, (DataSource)object));
                jPopupMenu.add(new ReportTreeActions.Copy(this, object));
                jPopupMenu.add(new ReportTreeActions.Delete(this, object));
                jPopupMenu.addSeparator();
                jPopupMenu.add(new ReportTreeActions.OpenDataSource(this, (DataSource)object));
                return jPopupMenu;
            }
            if (object instanceof PageSetup) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.EditPageSetup(this, (PageSetup)object));
                jPopupMenu.add(new ReportTreeActions.Copy(this, object));
                ReportTreeActions.Delete delete = new ReportTreeActions.Delete(this, object);
                delete.setEnabled(this.m_Report.getPageSetupCount() > 1);
                jPopupMenu.add(delete);
                return jPopupMenu;
            }
            if (object instanceof Section) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.EditSection(this, (Section)object));
                jPopupMenu.add(new ReportTreeActions.Copy(this, object));
                ReportTreeActions.Delete delete = new ReportTreeActions.Delete(this, object);
                delete.setEnabled(delete.isEnabled() && this.m_Report.getSectionCount() > 1);
                jPopupMenu.add(delete);
                return jPopupMenu;
            }
            if (object instanceof Style) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ReportTreeActions.EditStyle(this, (Style)object));
                jPopupMenu.add(new ReportTreeActions.Copy(this, object));
                ReportTreeActions.Delete delete = new ReportTreeActions.Delete(this, object);
                jPopupMenu.add(delete);
                return jPopupMenu;
            }
            if (object instanceof StylesheetRef) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                ReportTreeActions.Delete delete = new ReportTreeActions.Delete(this, object);
                jPopupMenu.add(delete);
                return jPopupMenu;
            }
        }
        return null;
    }

    @Override
    public void doDoubleClick(Object object) {
        if (object == this.m_Report) {
            ReportTreeActions.EditReport editReport = new ReportTreeActions.EditReport(this);
            ((ElixirAction)editReport).actionPerformed(null);
        } else if (object instanceof DataSource) {
            ReportTreeActions.EditDataSource editDataSource = new ReportTreeActions.EditDataSource(this, (DataSource)object);
            ((ElixirAction)editDataSource).actionPerformed(null);
        } else if (object instanceof PageSetup) {
            ReportTreeActions.EditPageSetup editPageSetup = new ReportTreeActions.EditPageSetup(this, (PageSetup)object);
            ((ElixirAction)editPageSetup).actionPerformed(null);
        } else if (object instanceof Section) {
            ReportTreeActions.EditSection editSection = new ReportTreeActions.EditSection(this, (Section)object);
            ((ElixirAction)editSection).actionPerformed(null);
        } else if (object instanceof Style) {
            ReportTreeActions.EditStyle editStyle = new ReportTreeActions.EditStyle(this, (Style)object);
            ((ElixirAction)editStyle).actionPerformed(null);
        } else if (object instanceof StylesheetRef) {
            ReportTreeActions.EditStylesheet editStylesheet = new ReportTreeActions.EditStylesheet(this, (StylesheetRef)object);
            ((ElixirAction)editStylesheet).actionPerformed(null);
        }
    }

    @Override
    public Object getRoot() {
        return this.m_Report;
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    @Override
    public int getChildCount(Object object) {
        if (object == this.m_Report) {
            return this.m_Wrappers.size();
        }
        if (object instanceof WrapperNode) {
            return ((WrapperNode)object).getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object == this.m_Report) {
            return false;
        }
        return !(object instanceof WrapperNode);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.remove(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object == this.m_Report) {
            return this.m_Wrappers.get(n);
        }
        return ((WrapperNode)object).getChild(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.m_Report) {
            return this.m_Wrappers.indexOf(object2);
        }
        return ((WrapperNode)object).getIndexOf(object2);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        if (string.equals("RawReport.Name")) {
            this.fireTreeNodeChanged(this.m_Report);
        } else {
            int n = -1;
            if (string.equals("RawReport.DataSource")) {
                n = 0;
            } else if (string.equals("RawReport.PageSetup")) {
                n = 1;
            } else if (string.equals("RawReport.Section")) {
                n = 2;
            } else if (string.equals("RawReport.Style")) {
                n = 3;
            } else if (string.equals("RawReport.Stylesheet")) {
                n = 4;
            }
            if (n >= 0) {
                WrapperNode wrapperNode = this.m_Wrappers.get(n);
                wrapperNode.refresh();
                this.fireChildrenChanged(wrapperNode);
            }
        }
        this.m_Report.setDirty(true);
    }

    protected void findFreeName(DataSource dataSource) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.m_Report.getDataSourceIterator();
        while (iterator.hasNext()) {
            hashSet.add(((DataSource)iterator.next()).getName());
        }
        String string = dataSource.getName();
        if (hashSet.contains(string)) {
            int n = 1;
            while (hashSet.contains(string + " Copy " + n)) {
                ++n;
            }
            dataSource.setName(string + " Copy " + n);
        }
    }

    protected void findFreeName(PageSetup pageSetup) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.m_Report.getPageSetupIterator();
        while (iterator.hasNext()) {
            hashSet.add(((PageSetup)iterator.next()).getName());
        }
        String string = pageSetup.getName();
        if (hashSet.contains(string)) {
            int n = 1;
            while (hashSet.contains(string + " Copy " + n)) {
                ++n;
            }
            pageSetup.setName(string + " Copy " + n);
        }
    }

    protected void findFreeName(Section section) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.m_Report.getSectionIterator();
        while (iterator.hasNext()) {
            hashSet.add(((Section)iterator.next()).getName());
        }
        String string = section.getName();
        if (hashSet.contains(string)) {
            int n = 1;
            while (hashSet.contains(string + " Copy " + n)) {
                ++n;
            }
            section.setName(string + " Copy " + n);
        }
    }

    protected void findFreeName(Style style) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.m_Report.getStyleIterator();
        while (iterator.hasNext()) {
            hashSet.add(((Style)iterator.next()).getName());
        }
        String string = style.getName();
        if (hashSet.contains(string)) {
            int n = 1;
            while (hashSet.contains(string + " Copy " + n)) {
                ++n;
            }
            style.setName(string + " Copy " + n);
        }
    }

    protected WrapperNode getWrapperFor(Object object) {
        if (object instanceof DataSource) {
            return this.m_Wrappers.get(0);
        }
        if (object instanceof PageSetup) {
            return this.m_Wrappers.get(1);
        }
        if (object instanceof Section) {
            return this.m_Wrappers.get(2);
        }
        if (object instanceof Style) {
            return this.m_Wrappers.get(3);
        }
        if (object instanceof StylesheetRef) {
            return this.m_Wrappers.get(4);
        }
        return null;
    }

    protected void fireTreeNodeChanged(Object object) {
        TreeModelEvent treeModelEvent = null;
        if (object == this.m_Report) {
            treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.m_Report));
        } else {
            WrapperNode wrapperNode = this.getWrapperFor(object);
            int n = wrapperNode.getIndexOf(object);
            treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.m_Report, wrapperNode}, new int[]{n}, new Object[]{object});
        }
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
        this.m_Report.setDirty(true);
    }

    protected void fireChildrenChanged(WrapperNode wrapperNode) {
        int n = this.m_Wrappers.indexOf(wrapperNode);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.m_Report}, new int[]{n}, new Object[]{wrapperNode});
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
        if (this.m_Tree != null) {
            TreeUtil.expandTree(this.m_Tree);
        }
        this.m_Report.setDirty(true);
    }

    protected boolean hasError(DataSource dataSource) {
        String string = dataSource.getDataSourceName();
        if (StringUtil.notEmpty(string)) {
            if (string.startsWith("repository:")) {
                string = string.substring(11);
            }
            return this.m_Repository.getFile(string) == null;
        }
        return true;
    }

    protected boolean hasError(Section section) {
        String string = section.getPageSetup();
        if (this.m_Report.getPageSetup(string) == null) {
            return true;
        }
        String string2 = section.getDataSource();
        return StringUtil.notEmpty(string2) && this.m_Report.getDataSource(string2) == null;
    }

    protected class WrapperNode {
        private Name m_Name;
        private List m_List;
        private Map m_Map;

        public WrapperNode(Name name, List list) {
            this.m_Name = name;
            this.m_List = list;
        }

        public WrapperNode(Name name, Map map) {
            this.m_Name = name;
            this.m_Map = map;
            this.m_List = new ArrayList();
            this.m_List.addAll(this.m_Map.values());
        }

        public void refresh() {
            if (this.m_Map != null) {
                this.m_List = new ArrayList();
                this.m_List.addAll(this.m_Map.values());
            }
        }

        public Name getName() {
            return this.m_Name;
        }

        public int getChildCount() {
            return this.m_List.size();
        }

        public Object getChild(int n) {
            return this.m_List.get(n);
        }

        public int getIndexOf(Object object) {
            return this.m_List.indexOf(object);
        }
    }
}

