/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.report;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.erd.reportdesigner.report.SectionInvocationWizard;
import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.erd.util.DerivedTableModel;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.ReportLoader;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.ISequenceStep;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.SectionInvocation;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SectionInvocationPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    RawReport m_Report;
    DerivedTableModel m_Model;
    OrderedEditableTable m_Table;
    Repository m_Repository;
    private static Color DEFAULT_COLOR = UIManager.getColor("Table.foreground");

    public SectionInvocationPanel(RawReport rawReport) {
        this.m_Report = rawReport;
        this.m_Repository = (Repository)Elixir.get(Repository.class);
        this.setBorder(new TitledBorder(new JLabel(I18N.ERD.getString("SectionInvocationPanel.render-seq.text"))));
        this.setLayout(new BorderLayout());
        DerivedTableModel.Column[] columnArray = new DerivedTableModel.Column[]{new DerivedTableModel.Column(this.name("SectionInvocation.ReportName")), new DerivedTableModel.Column(this.name("SectionInvocation.SectionName")), new DerivedTableModel.Column(this.name("SectionInvocation.DataSourceName")), new DerivedTableModel.NotifierColumn(this.name("SectionInvocation.Enabled"), 0, this)};
        this.m_Model = new DerivedTableModel((ChangeNotifier)this.m_Report, this.m_Report.getSequenceStepList(), "RawReport.SequenceStep", columnArray);
        this.m_Table = new OrderedEditableTable(this.m_Model, true);
        this.m_Table.setSingleSelectionMode();
        this.m_Table.setAutoResizeMode(1);
        this.m_Table.setColumnRenderer(0, new ReportNameRenderer());
        this.m_Table.setColumnRenderer(1, new SectionNameRenderer());
        this.m_Table.setColumnRenderer(2, new DataSourceNameRenderer());
        TableColumnModel tableColumnModel = this.m_Table.getTable().getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(3);
        int n = new JLabel((String)I18N.ERD.getString((String)"UI.enabled")).getPreferredSize().width + 40;
        tableColumn.setPreferredWidth(n);
        tableColumn.setMaxWidth(n);
        this.m_Table.addActionListener(this);
        this.add(this.m_Table);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.m_Report.setDirty(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            SectionInvocation sectionInvocation = new SectionInvocation();
            sectionInvocation.setEnabled(true);
            SectionInvocationWizard sectionInvocationWizard = new SectionInvocationWizard(this.m_Report, sectionInvocation);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(sectionInvocationWizard);
            if (sectionInvocationWizard.isFinished()) {
                this.m_Report.addSequenceStep((ISequenceStep)sectionInvocation);
                this.m_Table.select(this.m_Report.getSequenceStepCount() - 1);
                this.m_Report.setDirty(true);
            }
        } else if ("edit".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            if (n >= 0) {
                SectionInvocation sectionInvocation = (SectionInvocation)this.m_Report.getSequenceStep(n);
                SectionInvocationWizard sectionInvocationWizard = new SectionInvocationWizard(this.m_Report, sectionInvocation);
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                elixirFrame.showWizard(sectionInvocationWizard);
            }
        } else if ("minus".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            SectionInvocation sectionInvocation = (SectionInvocation)this.m_Report.getSequenceStep(n);
            this.m_Report.removeSequenceStep((ISequenceStep)sectionInvocation);
            this.m_Report.setDirty(true);
        } else if ("copy".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            SectionInvocation sectionInvocation = (SectionInvocation)this.m_Report.getSequenceStep(n);
            Holder holder = new Holder();
            holder.addContent((Object)sectionInvocation);
            ClipboardUtil.setHolder(holder);
        } else if ("paste".equals(string)) {
            Holder holder = ClipboardUtil.getHolder();
            Iterator iterator = holder.getContentIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SectionInvocation)) continue;
                SectionInvocation sectionInvocation = (SectionInvocation)e;
                this.m_Report.addSequenceStep((ISequenceStep)sectionInvocation);
                this.m_Report.setDirty(true);
            }
        } else if ("up".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Table.select(this.m_Model.moveUp(n));
            this.m_Report.setDirty(true);
        } else if ("down".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Table.select(this.m_Model.moveDown(n));
            this.m_Report.setDirty(true);
        }
    }

    private Name name(String string) {
        return I18N.getName(string);
    }

    protected RawReport getReport(int n) {
        String string = (String)this.m_Model.getValueAt(n, 0);
        if (StringUtil.isEmpty(string)) {
            return this.m_Report;
        }
        FileObject fileObject = this.m_Repository.getFileJ(string);
        if (fileObject == null) {
            return null;
        }
        try {
            return ReportLoader.readRML(fileObject);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private class ReportNameRenderer
    extends AbstractTCR {
        private ReportNameRenderer() {
        }

        @Override
        protected boolean isValid(Object object, int n) {
            String string = (String)object;
            if (StringUtil.isEmpty(string)) {
                return true;
            }
            return SectionInvocationPanel.this.m_Repository.getFile(string) != null;
        }
    }

    private class SectionNameRenderer
    extends AbstractTCR {
        private SectionNameRenderer() {
        }

        @Override
        protected boolean isValid(Object object, int n) {
            String string = (String)object;
            if (StringUtil.isEmpty(string)) {
                return true;
            }
            RawReport rawReport = SectionInvocationPanel.this.getReport(n);
            if (rawReport == null) {
                return false;
            }
            return rawReport.getSection(string) != null;
        }
    }

    private class DataSourceNameRenderer
    extends AbstractTCR {
        private DataSourceNameRenderer() {
        }

        @Override
        protected boolean isValid(Object object, int n) {
            String string = (String)object;
            if (StringUtil.isEmpty(string)) {
                return true;
            }
            RawReport rawReport = SectionInvocationPanel.this.getReport(n);
            if (rawReport != null && rawReport != SectionInvocationPanel.this.m_Report && rawReport.getDataSource(string) != null) {
                return true;
            }
            return SectionInvocationPanel.this.m_Report.getDataSource(string) != null;
        }
    }

    private abstract class AbstractTCR
    extends DefaultTableCellRenderer {
        private AbstractTCR() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setForeground(this.isValid(object, n) ? DEFAULT_COLOR : Color.RED);
            return component;
        }

        protected abstract boolean isValid(Object var1, int var2);
    }
}

