/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.report;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.erd.reportdesigner.section.SectionField;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ISectionInvocation;
import com.elixirtech.report2.raw.model.ISequenceStep;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.SectionInvocation;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import javax.swing.JCheckBox;

public class SectionInvocationWizard
extends Wizard {
    RawReport m_Report;
    SectionInvocation m_SectionInvocation;
    private PageOne m_PageOne;

    public SectionInvocationWizard(RawReport rawReport, SectionInvocation sectionInvocation) {
        super(I18N.ERD.getString("SectionInvocationWizard.title"));
        this.m_Report = rawReport;
        this.m_SectionInvocation = sectionInvocation;
        this.m_PageOne = new PageOne();
        this.m_Pages.add(this.m_PageOne);
    }

    @Override
    public boolean performFinish() {
        this.m_PageOne.performFinish();
        this.m_Report.setDirty(true);
        return true;
    }

    private class PageOne
    extends RelativeLayoutWizardPage {
        private SectionField m_SectionField;
        private JCheckBox m_Enabled;

        public PageOne() {
            super("Section Sequence", null);
            boolean bl = SectionInvocationWizard.this.m_Report.getSequenceStepList().contains(SectionInvocationWizard.this.m_SectionInvocation);
            this.setTitle(bl ? I18N.ERD.getString("SectionInvocationWizard.title.edit") : I18N.ERD.getString("SectionInvocationWizard.title.add"));
            this.setMessage(I18N.ERD.getString("SectionInvocationWizard.message"));
            this.setWizard(SectionInvocationWizard.this);
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_SectionField = new SectionField(SectionInvocationWizard.this.m_Report, (ISectionInvocation)SectionInvocationWizard.this.m_SectionInvocation);
            this.m_Component.add("section", this.m_SectionField);
            this.m_Enabled = SwingFactory.newCheckBox("UI.enabled");
            this.m_Component.add(this.m_Enabled);
            this.m_Enabled.setSelected(SectionInvocationWizard.this.m_SectionInvocation.isEnabled());
            this.m_Layout.stickTop("section");
            this.m_Layout.stickLeft("section");
            this.m_Layout.stickRight("section");
            this.m_Layout.putBelow("UI.enabled", "section", 5);
            this.m_Layout.hCenter("UI.enabled");
            I18N.ERD_MAP.injectComponents("SectionInvocationWizard.", this.m_Component);
        }

        @Override
        public boolean isPageComplete() {
            boolean bl = true;
            this.setError(null);
            return bl;
        }

        protected void performFinish() {
            this.m_SectionField.save();
            SectionInvocationWizard.this.m_SectionInvocation.setEnabled(this.m_Enabled.isSelected());
            boolean bl = SectionInvocationWizard.this.m_Report.getSequenceStepList().contains(SectionInvocationWizard.this.m_SectionInvocation);
            if (!bl) {
                SectionInvocationWizard.this.m_Report.addSequenceStep((ISequenceStep)SectionInvocationWizard.this.m_SectionInvocation);
            }
        }
    }
}

