/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.sax;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.report2.raw.RMLSAXOut;
import com.elixirtech.sax.AbstractSAXOut;
import com.elixirtech.sax.EncryptedBean;
import com.elixirtech.sax.IBaseSAXOut;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.delegates.BaseDocumentSAXOut;
import com.elixirtech.sax.delegates.BasePointSAXOut;
import com.elixirtech.sax.delegates.BaseRectangleSAXOut;
import com.elixirtech.sax.delegates.BaseStringSAXOut;
import com.elixirtech.sax.delegates.EncryptedSAXOut;
import com.elixirtech.util.StringUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;

public class ERDSAXOut
extends AbstractSAXOut {
    public static final Namespace NS_ERD = Namespace.getNamespace((String)"erd", (String)"http://www.elixirtech.com/ElixirReport/ERD");
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ERDSAXOut.class);
    private static Map<String, IBeanSAXOut> m_Outputters;
    private static Map<Class<?>, IBaseSAXOut> m_BaseOutputters;
    private static String[] OUTPUTTERS;

    public static void process(ContentHandler contentHandler, IBean iBean) {
        new ERDSAXOut(contentHandler, iBean, false);
    }

    public static void process(ContentHandler contentHandler, IBean iBean, boolean bl) {
        new ERDSAXOut(contentHandler, iBean, bl);
    }

    public ERDSAXOut(ContentHandler contentHandler, Object object, boolean bl) {
        super(contentHandler, object, bl, NS_ERD);
    }

    public ElxLoggerJ getLog() {
        return m_Log;
    }

    protected IBeanSAXOut lookupBeanOutputter(IBean iBean) {
        IBeanSAXOut iBeanSAXOut = m_Outputters.get(iBean.getTagName());
        if (iBeanSAXOut == null) {
            iBeanSAXOut = RMLSAXOut.getBeanOutputter((IBean)iBean);
        }
        return iBeanSAXOut;
    }

    protected IBaseSAXOut lookupBaseOutputter(Object object) {
        return m_BaseOutputters.get(object.getClass());
    }

    static {
        OUTPUTTERS = new String[]{"PageSetup", "Frame", "Holder", "Parameter", "PageSetup", "SectionInvocation", "Style", "StyleItem", "Section", "Group", "DataSource"};
        m_Outputters = new HashMap<String, IBeanSAXOut>();
        m_BaseOutputters = new HashMap();
        try {
            for (int i = 0; i < OUTPUTTERS.length; ++i) {
                Class<?> clazz = Class.forName("com.elixirtech.report2.raw.model." + OUTPUTTERS[i] + "SAXOut");
                IBeanSAXOut iBeanSAXOut = (IBeanSAXOut)clazz.newInstance();
                String string = iBeanSAXOut.getTagName();
                if (string.indexOf("|") < 0) {
                    m_Outputters.put(string, iBeanSAXOut);
                    continue;
                }
                String[] stringArray = StringUtil.arrayOfSubstrings(string, '|');
                for (int j = 0; j < stringArray.length; ++j) {
                    m_Outputters.put(stringArray[j], iBeanSAXOut);
                }
            }
            m_BaseOutputters.put(String.class, (IBaseSAXOut)new BaseStringSAXOut());
            m_BaseOutputters.put(Point.class, (IBaseSAXOut)new BasePointSAXOut());
            m_BaseOutputters.put(Rectangle.class, (IBaseSAXOut)new BaseRectangleSAXOut());
            m_BaseOutputters.put(Document.class, (IBaseSAXOut)new BaseDocumentSAXOut());
            m_BaseOutputters.put(EncryptedBean.class, (IBaseSAXOut)new EncryptedSAXOut());
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't initialize outputters: " + String.valueOf(exception)));
        }
    }
}

