/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ISectionInvocation;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ParameterModel
extends ElxTableModel {
    public static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Value"};
    private List<com.elixirtech.report2.raw.model.Parameter> m_Items = new ArrayList<com.elixirtech.report2.raw.model.Parameter>();
    private ISectionInvocation m_SectionInvocation;

    public ParameterModel(ISectionInvocation iSectionInvocation) {
        super(I18N.ERD, COLUMNS);
        this.m_SectionInvocation = iSectionInvocation;
    }

    public void setDataSource(IDataSource iDataSource) {
        if (iDataSource != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = this.m_SectionInvocation.getParameterCount();
            for (int i = 0; i < n; ++i) {
                com.elixirtech.report2.raw.model.Parameter parameter = this.m_SectionInvocation.getParameter(i);
                hashMap.put(parameter.getKey(), parameter);
            }
            List list = iDataSource.getParameters();
            for (Parameter parameter : list) {
                String string = parameter.getName();
                com.elixirtech.report2.raw.model.Parameter parameter2 = (com.elixirtech.report2.raw.model.Parameter)hashMap.get(string);
                String string2 = parameter2 != null ? parameter2.getValue() : null;
                this.m_Items.add(new com.elixirtech.report2.raw.model.Parameter(string, string2));
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.m_Items.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        com.elixirtech.report2.raw.model.Parameter parameter = this.m_Items.get(n);
        if (n2 == 0) {
            return parameter.getKey();
        }
        return parameter.getValue();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            com.elixirtech.report2.raw.model.Parameter parameter = this.m_Items.get(n);
            String string = (String)object;
            if (string.trim().length() == 0) {
                string = null;
            }
            parameter.setValue(string);
        }
    }

    public void performFinish() {
        this.m_SectionInvocation.removeAllParameters();
        for (com.elixirtech.report2.raw.model.Parameter parameter : this.m_Items) {
            if (!StringUtil.notEmpty(parameter.getValue())) continue;
            this.m_SectionInvocation.addParameter(parameter);
        }
    }
}

