/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.erd.TemplateFileType;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.ReportLoader;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.ISectionInvocation;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.ElxComboBox;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Color;
import java.awt.Frame;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SectionField
extends JPanel {
    private ISectionInvocation m_SectionInvocation;
    private RawReport m_ThisReport;
    private boolean m_AllowEmpty;
    private FileObject m_ReportFO;
    private ArchLayout m_Layout = new ArchLayout();
    private JTextField m_Report;
    private ElxComboBox m_Section;
    private ElxComboBox m_DataSource;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SectionField.class);

    public SectionField(RawReport rawReport, ISectionInvocation iSectionInvocation) {
        this(rawReport, iSectionInvocation, false);
    }

    public SectionField(RawReport rawReport, ISectionInvocation iSectionInvocation, boolean bl) {
        this.setLayout(this.m_Layout);
        this.m_ThisReport = rawReport;
        this.m_SectionInvocation = iSectionInvocation;
        this.m_AllowEmpty = bl;
        this.m_Report = SwingFactory.newTextField("report");
        this.add(this.m_Report);
        String string = this.m_SectionInvocation.getReportName();
        if (StringUtil.isEmpty(string)) {
            this.m_ReportFO = RepositoryConverter.toFO(this.m_ThisReport.getFileObject());
        } else {
            try {
                this.m_ReportFO = (FileObject)RepositoryConverter.toFO(this.m_ThisReport.getFileObject()).find(string).get();
            }
            catch (Exception exception) {
                this.m_ReportFO = null;
            }
        }
        this.add(SwingFactory.newDotsButton("dots", new CodeBlock((Object)this, "dots")));
        this.add(SwingFactory.newButton("ADD.dots", new CodeBlock((Object)this, "addDS")));
        this.add(SwingFactory.newLabel("report-label"));
        this.add(SwingFactory.newLabel("section-label"));
        this.m_Section = new ElxComboBox();
        this.add("section", this.m_Section);
        this.add(SwingFactory.newLabel("DS.label"));
        this.m_DataSource = new ElxComboBox();
        this.add("ds", this.m_DataSource);
        this.m_Layout.stickLeft("report-label");
        this.m_Layout.vCenter("report-label", "report");
        this.m_Layout.putRight("report", "report-label,section-label,DS.label", 10);
        this.m_Layout.stickTop("report");
        this.m_Layout.stickTop("dots");
        this.m_Layout.stickRight("dots");
        this.m_Layout.putLeft("report", "dots");
        this.m_Layout.setHeight("dots", "report");
        this.m_Layout.stickLeft("section-label");
        this.m_Layout.vCenter("section-label", "section");
        this.m_Layout.stickRight("section");
        this.m_Layout.alignBelow("section", "report", 5);
        this.m_Layout.stickLeft("DS.label");
        this.m_Layout.vCenter("DS.label", "ds");
        this.m_Layout.vCenter("ADD.dots", "ds");
        this.m_Layout.setHeight("ADD.dots", "ds");
        this.m_Layout.stickRight("ADD.dots");
        this.m_Layout.putLeft("ds", "ADD.dots");
        this.m_Layout.alignBelow("ds", "section", 5);
        this.m_Layout.setHeight("ds", "section");
        this.fillSections();
        this.fillDataSources();
        this.m_Report.setText(this.m_SectionInvocation.getReportName());
        this.m_Section.setSelectedItem(this.m_SectionInvocation.getSectionName());
        this.m_DataSource.setSelectedItem(this.m_SectionInvocation.getDataSourceName());
        this.m_Report.getDocument().addDocumentListener(new DL());
        I18N.ERD_MAP.injectComponents("SectionField.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    public ISectionInvocation getSectionInvocation() {
        return this.m_SectionInvocation;
    }

    public void focusReport() {
        this.m_Report.requestFocus();
    }

    public void focusSection() {
        this.m_Section.requestFocus();
    }

    public void focusDataSource() {
        this.m_DataSource.requestFocus();
    }

    public String getSectionName() {
        return (String)this.m_Section.getSelectedItem();
    }

    public String getReportName() {
        FileObject fileObject = RepositoryConverter.toFO(this.m_ThisReport.getFileObject());
        if (this.m_ReportFO != null && this.m_ReportFO != fileObject) {
            return this.m_ReportFO.getPath().toString();
        }
        return "";
    }

    public String getDataSourceName() {
        return (String)this.m_DataSource.getSelectedItem();
    }

    public void dots() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), I18N.ERD.getString("RepositoryChooser.CHOOSE_A_REPORT"), repositoryExplorer.getFileTypeJ(TemplateFileType.MIME_TYPE()));
        if (this.m_ReportFO != null) {
            repositoryChooser.setSelection(this.m_ReportFO);
        }
        repositoryChooser.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(repositoryChooser);
        if (repositoryChooser.isOk()) {
            this.m_ReportFO = repositoryChooser.getSelection();
            if (this.m_ReportFO == RepositoryConverter.toFO(this.m_ThisReport.getFileObject())) {
                this.m_ReportFO = null;
            }
            this.m_Report.setText(this.m_ReportFO != null ? this.m_ReportFO.getPath().toString() : "");
        }
    }

    public void addDS() {
        DataSource dataSource = new DataSource();
        dataSource.setName(ReportUtil.getNextDataSourceName(this.m_ThisReport));
        AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_ThisReport, dataSource);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(addDataSourceWizard);
        if (addDataSourceWizard.isFinished()) {
            this.update();
            this.m_DataSource.setSelectedItem(dataSource.getName());
        }
    }

    public void save() {
        String string = this.m_Report.getText();
        if (string.startsWith("repository:")) {
            string = string.substring(11);
        }
        this.m_SectionInvocation.setReportName(string);
        this.m_SectionInvocation.setSectionName((String)this.m_Section.getSelectedItem());
        this.m_SectionInvocation.setDataSourceName((String)this.m_DataSource.getSelectedItem());
    }

    protected void update() {
        String string = this.m_Report.getText();
        if (StringUtil.notEmpty(string)) {
            if (string.startsWith("repository:")) {
                string = string.substring(11);
            }
            try {
                this.m_ReportFO = (FileObject)RepositoryConverter.toFO(this.m_ThisReport.getFileObject()).find(string).get();
            }
            catch (Exception exception) {
                this.m_ReportFO = null;
            }
            if (this.m_ReportFO != null && this.m_ReportFO.isFolder()) {
                this.m_ReportFO = null;
            }
            this.m_Report.setForeground(this.m_ReportFO != null ? Color.black : Color.red);
        } else {
            this.m_ReportFO = RepositoryConverter.toFO(this.m_ThisReport.getFileObject());
        }
        this.fillSections();
        this.fillDataSources();
    }

    protected void fillSections() {
        String string = null;
        if (this.m_Section.getSelectedIndex() >= 0) {
            string = (String)this.m_Section.getSelectedItem();
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        if (this.m_ReportFO != null) {
            if (this.m_ReportFO == RepositoryConverter.toFO(this.m_ThisReport.getFileObject()) && this.m_AllowEmpty) {
                defaultComboBoxModel.addElement("");
            }
            try {
                List<String> list = ReportLoader.getSectionNames(this.m_ReportFO);
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    defaultComboBoxModel.addElement(iterator.next());
                }
                if (StringUtil.isEmpty(string) && defaultComboBoxModel.getSize() > 0) {
                    string = (String)defaultComboBoxModel.getElementAt(0);
                }
            }
            catch (IOException iOException) {
                ElixirJ.error(I18N.ERD.getString("SectionField.error-section") + String.valueOf(this.m_ReportFO) + ":" + String.valueOf(iOException), iOException);
            }
        }
        this.m_Section.setModel((ComboBoxModel)defaultComboBoxModel);
        this.m_Section.setSelectedItem(string);
    }

    protected void fillDataSources() {
        String string = null;
        if (this.m_DataSource.getSelectedIndex() >= 0) {
            string = (String)this.m_DataSource.getSelectedItem();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(ReportLoader.getDataSourceNames(this.m_ThisReport));
        if (this.m_ReportFO != null && this.m_ReportFO != RepositoryConverter.toFO(this.m_ThisReport.getFileObject())) {
            try {
                treeSet.addAll(ReportLoader.getDataSourceNames(this.m_ReportFO));
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Can't load report from " + String.valueOf(this.m_ReportFO.getPath())));
            }
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        defaultComboBoxModel.addElement(null);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement(iterator.next());
        }
        this.m_DataSource.setModel((ComboBoxModel)defaultComboBoxModel);
        this.m_DataSource.setSelectedItem(string);
    }

    private class DL
    implements DocumentListener {
        private DL() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            SectionField.this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SectionField.this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SectionField.this.update();
            if (StringUtil.isEmpty(SectionField.this.m_Report.getText())) {
                SectionField.this.m_Section.setSelectedItem(null);
            }
        }
    }
}

