/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.erd.reportdesigner.section.SectionWizard;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.ElxComboBox;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.util.StringUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SectionTab
extends TabComponent
implements ItemListener {
    private static String DS_NONE = I18N.ERD.getString("SectionTab.none");
    private SectionWizard m_Wizard;
    private RawReport m_Report;
    private Section m_Section;
    private ArchLayout m_Layout;
    private JTextField m_Name;
    private ElxComboBox m_DataSource;
    private JCheckBox m_KeepBlankPages;
    private ElxComboBox m_PageSetup;
    private JCheckBox m_ShowSectionHeader;
    private JCheckBox m_ShowSectionFooter;
    private JCheckBox m_ShowPageHeader;
    private JCheckBox m_ShowPageFooter;
    private JCheckBox m_ResetPageCount;

    public SectionTab(SectionWizard sectionWizard, RawReport rawReport, Section section) {
        this.m_Wizard = sectionWizard;
        this.m_Report = rawReport;
        this.m_Section = section;
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Name = this.m_Layout.addField(this, "name", SwingFactory.newLabel("name"));
        this.m_Layout.addLabel((JComponent)this, SwingFactory.newLabel("DS.label"), "ds");
        this.m_DataSource = new ElxComboBox(this.getDataSources());
        this.m_KeepBlankPages = SwingFactory.newCheckBox("keep");
        this.add(this.m_KeepBlankPages);
        this.m_Layout.addLabel((JComponent)this, SwingFactory.newLabel("ps-label"), "ps");
        this.m_PageSetup = new ElxComboBox(this.getPageSetups());
        this.add("ds", this.m_DataSource);
        this.add("keep", this.m_KeepBlankPages);
        this.add("ps", this.m_PageSetup);
        this.m_ShowSectionHeader = SwingFactory.newCheckBox("showsh");
        this.add(this.m_ShowSectionHeader);
        this.m_ShowSectionFooter = SwingFactory.newCheckBox("showsf");
        this.add(this.m_ShowSectionFooter);
        this.m_ShowPageHeader = SwingFactory.newCheckBox("showph");
        this.add(this.m_ShowPageHeader);
        this.m_ShowPageFooter = SwingFactory.newCheckBox("showpf");
        this.add(this.m_ShowPageFooter);
        this.m_ResetPageCount = SwingFactory.newCheckBox("resetpc");
        this.add(this.m_ResetPageCount);
        this.m_Layout.stickTop("name");
        this.m_Layout.putRight("name", "name-label,DS.label,ps-label", 10);
        this.m_Layout.alignBelow("ds", "name", 5);
        this.m_Layout.vCenter("keep", "ds");
        this.m_Layout.stickRight("keep");
        this.m_Layout.putLeft("ds", "keep");
        this.m_Layout.alignBelow("ps", "ds", 5);
        this.m_Layout.alignBelow("showsh", "ps");
        this.m_Layout.stickRight("ps");
        this.m_Layout.putBelow("showsf", "ps");
        this.m_Layout.putRight("showsf", "showsh,showph", 10);
        this.m_Layout.alignBelow("showph", "showsh");
        this.m_Layout.putBelow("showpf", "showsh");
        this.m_Layout.putRight("showpf", "showsh,showph", 10);
        this.m_Layout.alignBelow("resetpc", "showph");
        this.m_Name.setText(this.m_Section.getName());
        this.m_Name.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
        String string = this.m_Section.getDataSource();
        if (StringUtil.isEmpty(string)) {
            this.m_DataSource.setSelectedItem(DS_NONE);
        } else {
            this.m_DataSource.setSelectedItem(string);
        }
        this.m_DataSource.addItemListener(this);
        this.m_KeepBlankPages.setSelected(this.m_Section.isKeepBlankPages());
        String string2 = this.m_Section.getPageSetup();
        this.m_PageSetup.setSelectedItem(string2);
        this.m_PageSetup.addItemListener(this);
        this.m_ShowSectionHeader.setSelected(this.m_Section.isShowSectionHeader());
        this.m_ShowSectionFooter.setSelected(this.m_Section.isShowSectionFooter());
        this.m_ShowPageHeader.setSelected(this.m_Section.isShowPageHeader());
        this.m_ShowPageFooter.setSelected(this.m_Section.isShowPageFooter());
        this.m_ResetPageCount.setSelected(this.m_Section.isResetPageCount());
        I18N.ERD_MAP.injectComponents("SectionTab.", this);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("SectionTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("SectionTab.message");
    }

    public String getSectionName() {
        return this.m_Name.getText();
    }

    public boolean isDataSourceValid() {
        return !this.m_DataSource.isInvalid();
    }

    public boolean isPageSetupValid() {
        return !this.m_PageSetup.isInvalid();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_Wizard.getContainer().updateButtons();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void performFinish() {
        this.m_Section.setName(this.m_Name.getText().trim());
        String string = (String)this.m_DataSource.getSelectedItem();
        if (DS_NONE.equals(string)) {
            string = null;
        }
        this.m_Section.setDataSource(string);
        this.m_Section.setKeepBlankPages(this.m_KeepBlankPages.isSelected());
        String string2 = (String)this.m_PageSetup.getSelectedItem();
        this.m_Section.setPageSetup(string2);
        this.m_Section.setShowSectionHeader(this.m_ShowSectionHeader.isSelected());
        this.m_Section.setShowSectionFooter(this.m_ShowSectionFooter.isSelected());
        this.m_Section.setShowPageHeader(this.m_ShowPageHeader.isSelected());
        this.m_Section.setShowPageFooter(this.m_ShowPageFooter.isSelected());
        this.m_Section.setResetPageCount(this.m_ResetPageCount.isSelected());
    }

    protected DataSchema getDataSchema() {
        String string = (String)this.m_DataSource.getSelectedItem();
        if (string == null || DS_NONE.equals(string)) {
            return null;
        }
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            DataSource dataSource = this.m_Report.getDataSource(string);
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
            if (iDataSource != null) {
                return iDataSource.getSchema();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected String[] getDataSources() {
        int n = this.m_Report.getDataSourceCount();
        String[] stringArray = new String[n + 1];
        stringArray[0] = DS_NONE;
        for (int i = 0; i < n; ++i) {
            stringArray[i + 1] = this.m_Report.getDataSource(i).getName();
        }
        return stringArray;
    }

    protected String[] getPageSetups() {
        int n = this.m_Report.getPageSetupCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_Report.getPageSetup(i).getName();
        }
        return stringArray;
    }
}

