/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.arch.wizard.TabbedWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.erd.reportdesigner.section.SectionTab;
import com.elixirtech.erd.reportdesigner.section.SortTab;
import com.elixirtech.erd.reportdesigner.section.WatermarkTab;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.IRenderScriptHolder;
import com.elixirtech.report2.raw.model.ISequenceStep;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionInvocation;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.tab.ScriptTab;
import java.awt.Component;

public class SectionWizard
extends Wizard {
    RawReport m_Report;
    Section m_Section;
    private TabbedPage m_Tabs;
    SectionTab m_SectionTab;
    private WatermarkTab m_WatermarkTab;
    private SortTab m_SortTab;
    private ScriptTab m_ScriptTab;

    public SectionWizard(RawReport rawReport, Section section) {
        super(I18N.ERD.getString("SectionWizard.title"));
        this.m_Report = rawReport;
        this.setReadOnly(this.m_Report.getSecurity().isReadOnly());
        this.m_Section = section;
        if (!this.m_Report.getSectionList().contains(this.m_Section) && this.m_Report.getPageSetupCount() > 0) {
            this.m_Section.setPageSetup(this.m_Report.getPageSetup(0).getName());
        }
        this.buildPages();
        I18N.ERD_MAP.injectObject(null, this, "SectionWizard");
    }

    public void showScriptTab() {
        this.m_Tabs.selectTab(this.m_ScriptTab);
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        this.m_Tabs.performFinish();
        if (!this.m_Report.getSectionList().contains(this.m_Section)) {
            this.m_Report.addSection(this.m_Section);
            SectionInvocation sectionInvocation = new SectionInvocation();
            sectionInvocation.setSectionName(this.m_Section.getName());
            sectionInvocation.setEnabled(true);
            this.m_Report.addSequenceStep((ISequenceStep)sectionInvocation);
        }
        this.m_Report.setDirty(true);
        return true;
    }

    protected void buildPages() {
        this.m_Tabs = new TabbedPage();
        this.m_Tabs.setWizard(this);
        this.m_Tabs.setTitle(I18N.ERD.getString("SectionWizard.title"));
        this.m_SectionTab = new SectionTab(this, this.m_Report, this.m_Section);
        this.m_WatermarkTab = new WatermarkTab(this.m_Report, this.m_Section);
        this.m_SortTab = new SortTab(this, this.m_Section);
        this.m_ScriptTab = new ScriptTab((IRenderScriptHolder)this.m_Section);
        this.m_Tabs.addTab(this.m_SectionTab);
        this.m_Tabs.addTab(this.m_WatermarkTab);
        this.m_Tabs.addTab(this.m_SortTab);
        this.m_Tabs.addTab(this.m_ScriptTab);
        this.m_Tabs.setReadOnly(this.isReadOnly());
        this.m_Pages.add(this.m_Tabs);
    }

    protected DataSchema getSchema() {
        return this.m_SectionTab.getDataSchema();
    }

    private class TabbedPage
    extends TabbedWizardPage {
        public TabbedPage() {
            super("Section", null);
        }

        @Override
        public Component getComponent() {
            return this.m_Component;
        }

        @Override
        public void setReadOnly(boolean bl) {
            Component[] componentArray = this.m_Tabs.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(!SectionWizard.this.isReadOnly());
            }
        }

        @Override
        public boolean isPageComplete() {
            this.setError(null);
            boolean bl = true;
            String string = SectionWizard.this.m_SectionTab.getSectionName();
            if (StringUtil.isEmpty(string)) {
                this.setError(I18N.ERD.getString("Wizard.name-required"));
                bl = false;
            }
            Section section = SectionWizard.this.m_Report.getSection(string);
            if (bl && section != null && section != SectionWizard.this.m_Section) {
                this.setError(I18N.ERD.getString("Wizard.name-mustbeunique"));
                bl = false;
            }
            if (bl && !SectionWizard.this.m_SectionTab.isDataSourceValid()) {
                this.setError(I18N.ERD.getString("Wizard.ds-required"));
                bl = false;
            }
            if (bl && !SectionWizard.this.m_SectionTab.isPageSetupValid()) {
                this.setError(I18N.ERD.getString("SectionWizard.page-required"));
                bl = false;
            }
            this.m_Wizard.getContainer().updateMessage();
            return bl;
        }
    }
}

