/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.erd.reportdesigner.section.SortDialog;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.table.ElxTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;

public class SortModel
extends ElxTableModel {
    private static String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.SortOrder", "TableModel.GroupOn", "TableModel.GroupData"};
    private Section m_Section;
    private DataSchema m_Schema;
    private JTable m_Table;
    private List<Group> m_Items = new ArrayList<Group>();

    public SortModel(Section section) {
        super(I18N.ERD, COLUMNS);
        this.m_Section = section;
        this.m_Items.addAll(this.m_Section.getGroupList());
    }

    public List<Group> getGroups() {
        return Collections.unmodifiableList(this.m_Items);
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void setTable(JTable jTable) {
        this.m_Table = jTable;
    }

    @Override
    public int getRowCount() {
        return this.m_Items.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Group group = this.m_Items.get(n);
        if (n2 == 0) {
            return group.getField();
        }
        if (n2 == 1) {
            return com.elixirtech.wizard.sort.SortDialog.getSortDisplayName(group.getSortOrder());
        }
        if (n2 == 2) {
            return com.elixirtech.wizard.sort.SortDialog.getGroupDisplayName(group.getGroupOn());
        }
        if (n2 == 3) {
            return group.getGroupData();
        }
        return null;
    }

    public void add() {
        Group group = new Group();
        group.setGroupOn("None");
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        SortDialog sortDialog = new SortDialog(elixirFrame.getFrame(), I18N.ERD.getString("SortModel.sort-dialog.title"), this.m_Schema, group);
        elixirFrame.showModal(sortDialog);
        if (sortDialog.isOk()) {
            int n = this.m_Items.size();
            this.m_Items.add(group);
            this.fireTableRowsInserted(n, n);
            this.m_Table.setRowSelectionInterval(n, n);
        }
    }

    public void edit() {
        int n = this.m_Table.getSelectedRow();
        if (n >= 0) {
            Group group = this.m_Items.get(n);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            SortDialog sortDialog = new SortDialog(elixirFrame.getFrame(), I18N.ERD.getString("SortModel.sort-dialog.title"), this.m_Schema, group);
            elixirFrame.showModal(sortDialog);
            if (sortDialog.isOk()) {
                this.fireTableRowsUpdated(n, n);
            }
        }
    }

    public void moveUp() {
        int n = this.m_Table.getSelectedRow();
        Group group = this.m_Items.remove(n);
        this.m_Items.add(--n, group);
        this.fireTableRowsUpdated(n, n + 1);
        this.m_Table.setRowSelectionInterval(n, n);
    }

    public void moveDown() {
        int n = this.m_Table.getSelectedRow();
        Group group = this.m_Items.remove(n);
        this.m_Items.add(++n, group);
        this.fireTableRowsUpdated(n - 1, n);
        this.m_Table.setRowSelectionInterval(n, n);
    }

    public void remove() {
        int n = this.m_Table.getSelectedRow();
        this.m_Items.remove(n);
        this.fireTableRowsDeleted(n, n);
        if (n >= this.m_Items.size()) {
            --n;
        }
        if (n >= 0) {
            this.m_Table.setRowSelectionInterval(n, n);
        }
    }
}

