/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.erd.UIConstants;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.sort.SortDialog;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SortPanel
extends JPanel {
    public static final String DATA_LABEL = "data-label";
    private boolean m_RefreshCombo;
    private ArchLayout m_Layout;
    private DataSchema m_Schema;
    private Group m_Group;
    private JComboBox m_Name;
    private I18NComboBox m_SortOrder;
    private I18NComboBox m_GroupOn;
    private JTextField m_GroupData;
    private JLabel m_DataLabel;
    private JCheckBox m_ShowGroupHeader;
    private JCheckBox m_ShowGroupFooter;

    public SortPanel(DataSchema dataSchema, Group group) {
        this.m_Schema = dataSchema;
        this.m_Group = group;
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Name = SwingFactory.newComboBox("name", this.getNames());
        this.add(this.m_Name);
        this.m_Name.setSelectedItem(this.m_Group.getField());
        this.m_SortOrder = I18NComboBox.apply(I18NComboBox.buildNames(UIConstants.IDS, I18N.ERD, UIConstants.KEYS));
        this.m_SortOrder.setSelectedId(this.m_Group.getSortOrder());
        this.m_GroupOn = I18NComboBox.apply(this.getGroupOn());
        this.m_GroupOn.setSelectedId(this.m_Group.getGroupOn());
        this.m_GroupData = SwingFactory.newTextField("groupData", 32);
        this.add(this.m_GroupData);
        this.m_GroupData.setText(this.m_Group.getGroupData());
        this.m_ShowGroupHeader = SwingFactory.newCheckBox("SORT.show-group-header");
        this.add(this.m_ShowGroupHeader);
        this.m_ShowGroupHeader.setSelected(this.m_Group.isGroupHeaderVisible());
        this.m_ShowGroupFooter = SwingFactory.newCheckBox("SORT.show-group-footer");
        this.add(this.m_ShowGroupFooter);
        this.m_ShowGroupFooter.setSelected(this.m_Group.isGroupFooterVisible());
        this.m_Name.addItemListener(new CodeBlock((Object)this, "updateGroupOn"));
        this.m_GroupOn.addItemListener(new CodeBlock((Object)this, "updateGroupData"));
        this.add(SwingFactory.newLabel("UI.name"));
        this.add(SwingFactory.newLabel("SORT.sort-order"));
        this.add("sortOrder", this.m_SortOrder);
        this.add(SwingFactory.newLabel("SORT.group-on"));
        this.add("groupOn", this.m_GroupOn);
        this.m_DataLabel = SwingFactory.newLabel(DATA_LABEL);
        this.add(this.m_DataLabel);
        this.add("SORT.show-group-header", this.m_ShowGroupHeader);
        this.add("SORT.show-group-footer", this.m_ShowGroupFooter);
        this.m_Layout.stickLeft("UI.name");
        this.m_Layout.vCenter("UI.name", "name");
        this.m_Layout.stickLeft("SORT.sort-order");
        this.m_Layout.vCenter("SORT.sort-order", "sortOrder");
        this.m_Layout.stickLeft("SORT.group-on");
        this.m_Layout.vCenter("SORT.group-on", "groupOn");
        this.m_Layout.stickLeft(DATA_LABEL);
        this.m_Layout.vCenter(DATA_LABEL, "groupData");
        this.m_Layout.stickTop("name");
        this.m_Layout.putRight("name", "UI.name,SORT.sort-order,SORT.group-on,data-label", 10);
        this.m_Layout.stickRight("name");
        this.m_Layout.alignBelow("sortOrder", "name");
        this.m_Layout.stickRight("sortOrder");
        this.m_Layout.alignBelow("groupOn", "sortOrder");
        this.m_Layout.stickRight("groupOn");
        this.m_Layout.alignBelow("groupData", "groupOn");
        this.m_Layout.stickRight("groupData");
        this.m_Layout.stickLeft("SORT.show-group-header");
        this.m_Layout.putBelow("SORT.show-group-header", "groupData", 5);
        this.m_Layout.putBelow("SORT.show-group-footer", "groupData", 5);
        this.m_Layout.putRight("SORT.show-group-footer", "SORT.show-group-header", 10);
        I18N.ERD_MAP.injectComponents("SortPanel.", this);
        this.updateCombos();
    }

    public void onOk() {
        this.m_Group.setField((String)this.m_Name.getSelectedItem());
        this.m_Group.setSortOrder(this.m_SortOrder.getSelectedId());
        this.m_Group.setGroupOn(this.m_GroupOn.getSelectedId());
        if (this.m_GroupData.isVisible()) {
            this.m_Group.setGroupData(this.m_GroupData.getText());
        } else {
            this.m_Group.setGroupData("");
        }
        this.m_Group.setGroupHeaderVisible(this.m_ShowGroupHeader.isSelected());
        this.m_Group.setGroupFooterVisible(this.m_ShowGroupFooter.isSelected());
    }

    public void updateCombos() {
        if (!this.m_RefreshCombo) {
            this.m_RefreshCombo = true;
            try {
                this.updateGroupOn();
                this.updateGroupData();
            }
            finally {
                this.m_RefreshCombo = false;
            }
        }
    }

    public void updateGroupOn() {
        Object object = this.m_GroupOn.getSelectedItem();
        this.m_GroupOn.setModel(new DefaultComboBoxModel<Name>(this.getGroupOn()));
        this.m_GroupOn.setSelectedItem(object);
        if (this.m_GroupOn.getSelectedIndex() < 0 && this.m_GroupOn.getItemCount() > 0) {
            this.m_GroupOn.setSelectedIndex(0);
        }
    }

    public void updateGroupData() {
        String string = this.m_GroupOn.getSelectedId();
        if (string == null || string.equals("All") || string.equals("Each Value") || string.equals("None") || string.equals("Quarter")) {
            this.m_DataLabel.setText("");
            this.m_GroupData.setVisible(false);
        } else if (string.equals("Range")) {
            this.m_DataLabel.setText(I18N.ERD.getString("SortDialog.Range"));
            this.m_GroupData.setVisible(true);
        } else if (string.equals("Substring")) {
            this.m_DataLabel.setText(I18N.ERD.getString("SortDialog.StartEnd"));
            this.m_GroupData.setVisible(true);
        } else {
            this.m_DataLabel.setText(I18N.ERD.getString("SortDialog.GroupInterval"));
            this.m_GroupData.setVisible(true);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    private String[] getNames() {
        if (this.m_Schema != null) {
            int n = this.m_Schema.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.m_Schema.getColumnName(i);
            }
            return stringArray;
        }
        return new String[0];
    }

    private Name[] getGroupOn() {
        int n = this.m_Name.getSelectedIndex();
        if (n < 0) {
            return new Name[0];
        }
        DataType dataType = this.m_Schema.getColumnType(n);
        return SortDialog.getGroupDisplayNames(GrouperFactory.getGroupOnNames((DataType)dataType));
    }
}

