/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.section;

import com.elixirtech.erd.reportdesigner.section.SectionWizard;
import com.elixirtech.erd.reportdesigner.section.SortModel;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;

public class SortTab
extends TabComponent
implements ActionListener {
    private SectionWizard m_Wizard;
    private Section m_Section;
    SortModel m_Model;
    private OrderedEditableTable m_Table;

    public SortTab(SectionWizard sectionWizard, Section section) {
        this.m_Wizard = sectionWizard;
        this.m_Section = section;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.m_Model = new SortModel(this.m_Section);
        this.m_Table = new OrderedEditableTable(this.m_Model, true, false);
        this.m_Table.setAutoResizeMode(4);
        this.m_Model.setTable(this.m_Table.getTable());
        this.m_Table.addActionListener(this);
        this.add((Component)this.m_Table, "Center");
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("SortTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("SortTab.message");
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void entered() {
        super.entered();
        this.m_Model.setSchema(this.m_Wizard.getSchema());
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            this.m_Model.add();
        } else if ("minus".equals(string)) {
            this.m_Model.remove();
        } else if ("edit".equals(string)) {
            this.m_Model.edit();
        } else if ("up".equals(string)) {
            this.m_Model.moveUp();
        } else if ("down".equals(string)) {
            this.m_Model.moveDown();
        }
    }

    @Override
    public void performFinish() {
        List<Group> list = this.m_Model.getGroups();
        for (Group group : list) {
            group.setSection(this.m_Section);
        }
        this.m_Section.setGroupList(list);
    }
}

