/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.select;

import com.elixirtech.command.Command;
import com.elixirtech.command.CommandManager;
import com.elixirtech.erd.reportdesigner.HorizontalRuler;
import com.elixirtech.erd.reportdesigner.Ruler;
import com.elixirtech.erd.reportdesigner.VerticalRuler;
import com.elixirtech.erd.reportdesigner.select.SelectionEvent;
import com.elixirtech.erd.reportdesigner.select.SelectionListener;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.ReadOnlyHandleWrapper;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SelectionManager {
    private final RawReport m_Report;
    private final CommandManager m_CommandManager;
    List<RawModelElement> m_Selection = new ArrayList<RawModelElement>();
    private List<Handle> m_Handles = new ArrayList<Handle>();
    private List<SelectionListener> m_Listeners = new ArrayList<SelectionListener>();
    private SelectionEvent m_SelectionEvent = new SelectionEvent(this);
    private HorizontalRuler m_HRuler;
    private VerticalRuler m_VRuler;

    public SelectionManager(RawReport rawReport, CommandManager commandManager) {
        this.m_Report = rawReport;
        this.m_CommandManager = commandManager;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.m_Listeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.m_Listeners.remove(selectionListener);
    }

    public boolean isSelected(RawModelElement rawModelElement) {
        assert (rawModelElement != null) : "Element is null";
        return this.m_Selection.contains(rawModelElement);
    }

    public void addSelection(RawModelElement rawModelElement) {
        assert (rawModelElement != null) : "Element is null";
        this.m_CommandManager.doCommand(new AddElement(rawModelElement));
    }

    public void toggleSelection(RawModelElement rawModelElement) {
        assert (rawModelElement != null) : "Element is null";
        this.m_CommandManager.doCommand(new ToggleElement(rawModelElement));
    }

    public void toggleSelection(List<RawModelElement> list) {
        this.m_CommandManager.doCommand(new ToggleElements(list));
    }

    public void addSelection(List<RawModelElement> list) {
        this.m_CommandManager.doCommand(new AddElements(list));
    }

    public void setSelection(RawModelElement rawModelElement) {
        assert (rawModelElement != null) : "Element is null";
        this.m_CommandManager.doCommand(new SelectElement(rawModelElement));
    }

    public void forceSelection(RawModelElement rawModelElement) {
        this.m_Selection.clear();
        this.m_Selection.add(rawModelElement);
        this.buildHandles();
    }

    public void setSelection(List<RawModelElement> list) {
        this.m_CommandManager.doCommand(new SelectElements(list));
    }

    public void forceSelection(List<RawModelElement> list) {
        this.m_Selection.clear();
        this.m_Selection.addAll(list);
        this.buildHandles();
    }

    public void removeSelection(RawModelElement rawModelElement) {
        assert (rawModelElement != null) : "Element is null";
        this.m_CommandManager.doCommand(new RemoveElement(rawModelElement));
    }

    public void removeSelection(List<RawModelElement> list) {
        this.m_CommandManager.doCommand(new RemoveElements(list));
    }

    public void setReadOnly(boolean bl) {
        this.buildHandles();
    }

    public void removeAllSelections() {
        this.m_Selection.clear();
        this.m_Handles.clear();
        this.fireSelectionChanged();
    }

    public List<RawModelElement> getSelection() {
        return Collections.unmodifiableList(this.m_Selection);
    }

    public IRawElementHolder getSelectionParent() {
        if (this.m_Selection.size() == 0) {
            return null;
        }
        return this.m_Selection.get(0).getParent();
    }

    public int getSelectionCount() {
        return this.m_Selection.size();
    }

    public RawModelElement getSelection(int n) {
        return this.m_Selection.get(n);
    }

    public void setHRuler(HorizontalRuler horizontalRuler) {
        this.m_HRuler = horizontalRuler;
    }

    public void setVRuler(VerticalRuler verticalRuler) {
        this.m_VRuler = verticalRuler;
    }

    public void setCurrentRange(Rectangle rectangle) {
        this.m_HRuler.setCurrentRange(new Ruler.Range(rectangle.x, rectangle.x + rectangle.width));
        this.m_VRuler.setCurrentRange(new Ruler.Range(rectangle.y, rectangle.y + rectangle.height));
    }

    public void drawHandles(Graphics2D graphics2D) {
        for (Handle handle : this.m_Handles) {
            handle.draw(graphics2D);
        }
    }

    public Handle[] getHandlesAt(Point point) {
        Handle[] handleArray = null;
        Handle handle = this.getHandleAt(point);
        if (handle != null) {
            HashSet<Handle> hashSet = new HashSet<Handle>();
            for (Handle handle2 : this.m_Handles) {
                if (handle2.getId() != handle.getId()) continue;
                hashSet.add(handle2);
            }
            handleArray = new Handle[hashSet.size()];
            hashSet.toArray(handleArray);
        }
        return handleArray;
    }

    public Handle getHandleAt(Point point) {
        for (Handle handle : this.m_Handles) {
            if (!handle.isHit(point)) continue;
            return handle;
        }
        return null;
    }

    protected void buildHandles() {
        this.m_Handles.clear();
        boolean bl = this.m_Report.getSecurity().isReadOnly();
        for (RawModelElement rawModelElement : this.m_Selection) {
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (abstractShape == null) continue;
            int n = abstractShape.getHandleCount();
            for (int i = 0; i < n; ++i) {
                Handle handle = abstractShape.getHandle(i);
                if (bl) {
                    handle = new ReadOnlyHandleWrapper(handle);
                }
                this.m_Handles.add(handle);
            }
        }
        this.drawRanges();
        this.fireSelectionChanged();
    }

    public void drawRanges() {
        Iterator<RawModelElement> iterator = this.m_Selection.iterator();
        if (iterator.hasNext()) {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            Rectangle rectangle = new Rectangle();
            while (iterator.hasNext()) {
                RawModelElement rawModelElement = iterator.next();
                AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
                if (abstractShape == null) continue;
                abstractShape.getRect(rectangle);
                n = Math.min(n, rectangle.x);
                n2 = Math.max(n2, rectangle.x + rectangle.width);
                n3 = Math.min(n3, rectangle.y);
                n4 = Math.max(n4, rectangle.y + rectangle.height);
            }
            this.m_HRuler.setCurrentRange(new Ruler.Range(n, n2));
            this.m_VRuler.setCurrentRange(new Ruler.Range(n3, n4));
        } else {
            if (this.m_HRuler != null) {
                this.m_HRuler.setCurrentRange(null);
            }
            if (this.m_VRuler != null) {
                this.m_VRuler.setCurrentRange(null);
            }
        }
    }

    protected void fireSelectionChanged() {
        for (SelectionListener selectionListener : this.m_Listeners) {
            selectionListener.selectionChanged(this.m_SelectionEvent);
        }
    }

    protected void doAddSelection(RawModelElement rawModelElement) {
        IRawElementHolder iRawElementHolder;
        if (this.m_Selection.size() > 0 && (iRawElementHolder = this.getSelectionParent()) != rawModelElement.getParent()) {
            this.m_Selection.clear();
        }
        this.m_Selection.add(rawModelElement);
    }

    protected void doAddSelection(List<RawModelElement> list) {
        Iterator<RawModelElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.doAddSelection(iterator.next());
        }
    }

    protected void doRemoveSelection(RawModelElement rawModelElement) {
        this.m_Selection.remove(rawModelElement);
    }

    protected void doRemoveSelection(List<RawModelElement> list) {
        this.m_Selection.removeAll(list);
    }

    private class AddElement
    extends SelectionCommand {
        private RawModelElement m_Element;

        public AddElement(RawModelElement rawModelElement) {
            this.m_Element = rawModelElement;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            SelectionManager.this.doAddSelection(this.m_Element);
            SelectionManager.this.buildHandles();
        }
    }

    private class ToggleElement
    extends SelectionCommand {
        private RawModelElement m_Element;

        public ToggleElement(RawModelElement rawModelElement) {
            this.m_Element = rawModelElement;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            if (SelectionManager.this.m_Selection.contains(this.m_Element)) {
                SelectionManager.this.doRemoveSelection(this.m_Element);
            } else {
                SelectionManager.this.doAddSelection(this.m_Element);
            }
            SelectionManager.this.buildHandles();
        }
    }

    private class ToggleElements
    extends SelectionCommand {
        private List<RawModelElement> m_Elements;

        public ToggleElements(List<RawModelElement> list) {
            this.m_Elements = list;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            for (RawModelElement rawModelElement : this.m_Elements) {
                if (SelectionManager.this.m_Selection.contains(rawModelElement)) {
                    SelectionManager.this.doRemoveSelection(rawModelElement);
                    continue;
                }
                SelectionManager.this.doAddSelection(rawModelElement);
            }
            SelectionManager.this.buildHandles();
        }
    }

    private class AddElements
    extends SelectionCommand {
        private List<RawModelElement> m_Elements;

        public AddElements(List<RawModelElement> list) {
            this.m_Elements = list;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            SelectionManager.this.doAddSelection(this.m_Elements);
            SelectionManager.this.buildHandles();
        }
    }

    private class SelectElement
    extends SelectionCommand {
        private RawModelElement m_Element;

        public SelectElement(RawModelElement rawModelElement) {
            this.m_Element = rawModelElement;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            SelectionManager.this.m_Selection.clear();
            SelectionManager.this.doAddSelection(this.m_Element);
            SelectionManager.this.buildHandles();
        }
    }

    private class SelectElements
    extends SelectionCommand {
        private List<RawModelElement> m_Elements;

        public SelectElements(List<RawModelElement> list) {
            this.m_Elements = list;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            SelectionManager.this.m_Selection.clear();
            SelectionManager.this.doAddSelection(this.m_Elements);
            SelectionManager.this.buildHandles();
        }
    }

    private class RemoveElement
    extends SelectionCommand {
        private RawModelElement m_Element;

        public RemoveElement(RawModelElement rawModelElement) {
            this.m_Element = rawModelElement;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            SelectionManager.this.doRemoveSelection(this.m_Element);
            SelectionManager.this.buildHandles();
        }
    }

    private class RemoveElements
    extends SelectionCommand {
        private List<RawModelElement> m_Elements;

        public RemoveElements(List<RawModelElement> list) {
            this.m_Elements = list;
        }

        @Override
        public void doIt() {
            this.storeState();
            this.redoIt();
        }

        @Override
        public void undoIt() {
            this.restoreState();
            SelectionManager.this.buildHandles();
        }

        @Override
        public void redoIt() {
            SelectionManager.this.doRemoveSelection(this.m_Elements);
        }
    }

    private abstract class SelectionCommand
    implements Command {
        private List<RawModelElement> m_PreviousSelection = new ArrayList<RawModelElement>();

        private SelectionCommand() {
        }

        public void storeState() {
            this.m_PreviousSelection.addAll(SelectionManager.this.m_Selection);
        }

        public void restoreState() {
            SelectionManager.this.m_Selection.clear();
            SelectionManager.this.m_Selection.addAll(this.m_PreviousSelection);
        }
    }
}

