/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.MoveHandle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.Property;
import com.elixirtech.report2.raw.model.ShapeGroup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractRectShape
extends AbstractShape {
    public static final int MIN_WIDTH = 105;
    public static final int MIN_HEIGHT = 105;
    protected Handle[] m_Handles;

    public AbstractRectShape() {
        this.init();
        this.buildHandles();
    }

    @Override
    public abstract void setRect(Rectangle var1);

    @Override
    public abstract void getRect(Rectangle var1);

    protected void init() {
    }

    public void buildHandles() {
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        this.buildHandles(arrayList);
        this.m_Handles = new Handle[arrayList.size()];
        arrayList.toArray(this.m_Handles);
    }

    protected void buildHandles(List<Handle> list) {
        list.add(new SizeHandle(this, 1, Cursor.getPredefinedCursor(6)));
        list.add(new SizeHandle(this, 2, Cursor.getPredefinedCursor(7)));
        list.add(new SizeHandle(this, 3, Cursor.getPredefinedCursor(5)));
        list.add(new SizeHandle(this, 4, Cursor.getPredefinedCursor(4)));
        list.add(new MoveHandle(this, 0));
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        graphics2D.setColor(Color.white);
        graphics2D.fill(rectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(rectangle);
    }

    @Override
    public boolean contains(Point point) {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        return rectangle.contains(point);
    }

    @Override
    public int getHandleCount() {
        return this.m_Handles.length;
    }

    @Override
    public Handle getHandle(int n) {
        return this.m_Handles[n];
    }

    public void getPropertyNames(Set set) {
    }

    public Property getProperty(Name name) {
        throw new RuntimeException("Property: " + name.getName() + " not supported");
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        switch (n) {
            case 0: 
            case 1: {
                point.x = rectangle.x;
                point.y = rectangle.y;
                break;
            }
            case 2: {
                point.x = rectangle.x + rectangle.width - 1;
                point.y = rectangle.y;
                break;
            }
            case 3: {
                point.x = rectangle.x + rectangle.width - 1;
                point.y = rectangle.y + rectangle.height - 1;
                break;
            }
            case 4: {
                point.x = rectangle.x;
                point.y = rectangle.y + rectangle.height - 1;
            }
        }
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        Rectangle rectangle = this.getRect();
        int[] nArray = null;
        int[] nArray2 = null;
        if (!(this.getModel().getParent() instanceof ShapeGroup)) {
            nArray = this.getHRulers();
            nArray2 = this.getVRulers();
            this.snapToRulers(point, nArray, nArray2);
        }
        Rectangle rectangle2 = this.getContainerRect();
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        switch (n) {
            case 0: {
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.x + rectangle.width >= rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - rectangle.width - 1;
                }
                if (point.y < rectangle2.y) {
                    point.y = rectangle2.y;
                }
                if (point.y + rectangle.height >= rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - rectangle.height - 1;
                }
                rectangle.x = point.x;
                rectangle.y = point.y;
                Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                if (!(this.getModel().getParent() instanceof ShapeGroup)) {
                    this.snapToRulers(point2, nArray, nArray2);
                }
                rectangle.x = point2.x - rectangle.width;
                rectangle.y = point2.y - rectangle.height;
                break;
            }
            case 1: {
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.x + 105 > n2) {
                    point.x = n2 - 105;
                }
                if (point.y < rectangle2.x) {
                    point.y = rectangle2.y;
                }
                if (point.y + 105 > n3) {
                    point.y = n3 - 105;
                }
                rectangle.x = point.x;
                rectangle.y = point.y;
                rectangle.width = n2 - point.x;
                rectangle.height = n3 - point.y;
                break;
            }
            case 2: {
                if (point.x >= rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - 1;
                }
                if (point.x - 105 < rectangle.x) {
                    point.x = rectangle.x + 105;
                }
                if (point.y < rectangle2.x) {
                    point.y = rectangle2.y;
                }
                if (point.y + 105 > n3) {
                    point.y = n3 - 105;
                }
                rectangle.width = point.x - rectangle.x;
                rectangle.y = point.y;
                rectangle.height = n3 - point.y;
                break;
            }
            case 3: {
                if (point.x >= rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - 1;
                }
                if (point.x - 105 < rectangle.x) {
                    point.x = rectangle.x + 105;
                }
                if (point.y >= rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - 1;
                }
                if (point.y - 105 < rectangle.y) {
                    point.y = rectangle.y + 105;
                }
                rectangle.width = point.x - rectangle.x;
                rectangle.height = point.y - rectangle.y;
                break;
            }
            case 4: {
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.x + 105 > n2) {
                    point.x = n2 - 105;
                }
                if (point.y >= rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - 1;
                }
                if (point.y - 105 < rectangle.y) {
                    point.y = rectangle.y + 105;
                }
                rectangle.x = point.x;
                rectangle.width = n2 - point.x;
                rectangle.height = point.y - rectangle.y;
            }
        }
        this.setRect(rectangle);
    }

    protected int[] getHRulers() {
        return new int[0];
    }

    protected int[] getVRulers() {
        return new int[0];
    }

    protected Rectangle getContainerRect() {
        AbstractShape abstractShape = (AbstractShape)this.m_Model.getParent().getShape();
        if (abstractShape != null) {
            return abstractShape.getRect();
        }
        return null;
    }

    protected void snapToRulers(Point point, int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            if (Math.abs(point.x - nArray[n]) >= 80) continue;
            point.x = nArray[n];
            break;
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (Math.abs(point.y - nArray2[n]) >= 80) continue;
            point.y = nArray2[n];
            break;
        }
    }
}

