/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.BoxShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.PasteAction;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Box;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;

public class CellShape
extends UiModelElementShape
implements ChangeListener {
    private static Icon m_CellIcon = ERDIcons.CELL;

    @Override
    public void setModel(RawModelElement rawModelElement) {
        if (this.m_Model != null) {
            ((Cell)this.m_Model).removeChangeListener((ChangeListener)this);
        }
        super.setModel(rawModelElement);
        ((Cell)this.m_Model).addChangeListener((ChangeListener)this);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("Shape.Cell");
    }

    @Override
    public Icon getIcon() {
        return m_CellIcon;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isHolder() {
        return true;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        Box box;
        if (this.m_Model == changeNotifier && "Cell.Weight".equals(string) && (box = (Box)this.m_Model.getParent()) != null) {
            BoxShape boxShape = (BoxShape)box.getShape();
            boxShape.layoutCells();
        }
    }

    @Override
    public boolean isHandleLocked(int n) {
        boolean bl = super.isHandleLocked(n);
        if (!bl) {
            return n < 5;
        }
        return bl;
    }

    @Override
    public Action[] getPopupActions(Point point) {
        ChunkPanel chunkPanel = (ChunkPanel)this.getChunk().getChunkPanel();
        return new Action[]{new InsertCellAction(chunkPanel), new AppendCellAction(chunkPanel), new RemoveCellAction(chunkPanel), new PasteAction(chunkPanel)};
    }

    @Override
    public void setRect(Rectangle rectangle) {
        this.m_Model.setLeft(rectangle.x);
        this.m_Model.setTop(rectangle.y);
        this.m_Model.setWidth(rectangle.width);
        this.m_Model.setHeight(rectangle.height);
        Iterator iterator = ((Cell)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            rawModelElement.getShape().setRect(rectangle);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        Iterator iterator = ((Cell)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            ((AbstractShape)rawModelElement.getShape()).draw(graphics2D);
        }
    }

    private class InsertCellAction
    extends ERDAction {
        public InsertCellAction(ChunkPanel chunkPanel) {
            super("Cell.Insert");
            this.setEnabled(!chunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Cell cell = (Cell)CellShape.this.m_Model;
            Box box = (Box)cell.getParent();
            int n = box.indexOfCell(cell);
            Cell cell2 = new Cell();
            UiFactory.current().buildShape((RawModelElement)cell2);
            box.addCell(n, cell2);
            ((BoxShape)box.getShape()).layoutCells();
            CellShape.this.m_Model.getChunk().repaint();
            Chunk.MyTreeModel myTreeModel = box.getTreeModel();
            if (myTreeModel != null) {
                myTreeModel.fireInsertedEvent(myTreeModel.getTreePath((RawModelElement)box), new int[]{n}, new Object[]{cell2});
            }
        }
    }

    private class AppendCellAction
    extends ERDAction {
        public AppendCellAction(ChunkPanel chunkPanel) {
            super("Cell.Append");
            this.setEnabled(!chunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Cell cell = (Cell)CellShape.this.m_Model;
            Box box = (Box)cell.getParent();
            int n = box.indexOfCell(cell) + 1;
            Cell cell2 = new Cell();
            UiFactory.current().buildShape((RawModelElement)cell2);
            box.addCell(n, cell2);
            ((BoxShape)box.getShape()).layoutCells();
            CellShape.this.m_Model.getChunk().repaint();
            Chunk.MyTreeModel myTreeModel = box.getTreeModel();
            if (myTreeModel != null) {
                myTreeModel.fireInsertedEvent(myTreeModel.getTreePath((RawModelElement)box), new int[]{n}, new Object[]{cell2});
            }
        }
    }

    private class RemoveCellAction
    extends ERDAction {
        public RemoveCellAction(ChunkPanel chunkPanel) {
            super("Cell.Remove");
            Cell cell = (Cell)CellShape.this.m_Model;
            this.setEnabled(!chunkPanel.isReadOnly() && cell.getParent().getRawElementCount() > 1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Chunk chunk = CellShape.this.m_Model.getChunk();
            Cell cell = (Cell)CellShape.this.m_Model;
            Box box = (Box)cell.getParent();
            int n = box.indexOfCell(cell);
            box.removeCell(cell);
            ((BoxShape)box.getShape()).layoutCells();
            Cell cell2 = box.getCell(n > 0 ? n - 1 : 0);
            ((ChunkPanel)chunk.getChunkPanel()).getSelectionManager().setSelection((RawModelElement)cell2);
            chunk.repaint();
            Chunk.MyTreeModel myTreeModel = box.getTreeModel();
            if (myTreeModel != null) {
                myTreeModel.fireRemovedEvent(myTreeModel.getTreePath((RawModelElement)box), new int[]{n}, new Object[]{cell});
            }
        }
    }
}

