/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.IChunkPanel;
import com.elixirtech.report2.raw.model.IChunk;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Shape;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.Icon;

public class ChunkShape
extends UiModelElementShape {
    private static Icon m_ChunkIcon = ERDIcons.CHUNK;

    public ChunkShape(IChunk iChunk) {
        this.setModel((RawModelElement)iChunk);
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isHolder() {
        return true;
    }

    public void repaint() {
        ((IChunk)this.m_Model).getChunkPanel().repaintBody();
    }

    @Override
    public String getName() {
        return ((IChunk)this.m_Model).getChunkPanel().getChunkTitle();
    }

    @Override
    public Icon getIcon() {
        return m_ChunkIcon;
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public void sizeToFitChildren() {
        IChunk iChunk = this.chunk();
        IChunkPanel iChunkPanel = iChunk.getChunkPanel();
        int n = iChunk.getHeight();
        int n2 = 0;
        Iterator iterator = iChunk.getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (abstractShape == null) continue;
            Rectangle rectangle = abstractShape.getRect();
            n2 = Math.max(n2, rectangle.y + rectangle.height);
        }
        if (n2 > n) {
            iChunk.setHeight(n2);
            iChunkPanel.updateSize();
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        IChunk iChunk = this.chunk();
        Color color = StandardColor.lookup(iChunk.getBackgroundColor());
        if (rectangle == null) {
            if (color.getAlpha() > 0) {
                IChunkPanel iChunkPanel = iChunk.getChunkPanel();
                Rectangle rectangle2 = new Rectangle(0, 0, iChunkPanel.getChunkWidth(), iChunk.getHeight());
                graphics2D.setColor(color);
                graphics2D.fill(rectangle2);
            }
        } else if (color.getAlpha() > 0) {
            graphics2D.setColor(color);
            graphics2D.fill(rectangle);
        }
    }

    public void drawGrid(Graphics2D graphics2D, int n) {
        Rectangle rectangle = graphics2D.getClipBounds();
        RawReport rawReport = this.getReport();
        if (rawReport.isGridVisible()) {
            int n2 = rawReport.getGridX();
            int n3 = rawReport.getGridY();
            int n4 = 8000 / n;
            if (n2 >= n4 && n3 >= n4) {
                int n5 = 2000 / n + 1;
                graphics2D.setColor(StandardColor.lookup("ERD-Construction-Line"));
                int n6 = rectangle.x / n2 * n2;
                int n7 = rectangle.y / n3 * n3;
                int n8 = rectangle.x + rectangle.width;
                int n9 = rectangle.y + rectangle.height;
                for (int i = n7; i <= n9; i += n3) {
                    for (int j = n6; j < n8; j += n2) {
                        graphics2D.drawRect(j, i, n5, n5);
                    }
                }
            }
        }
    }

    public void drawShapes(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        IChunk iChunk = this.chunk();
        if (rectangle == null) {
            Iterator iterator = iChunk.getRawElementIterator();
            while (iterator.hasNext()) {
                RawModelElement rawModelElement = (RawModelElement)iterator.next();
                AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
                if (abstractShape == null) continue;
                abstractShape.draw(graphics2D);
            }
        } else {
            Rectangle rectangle2 = new Rectangle();
            Iterator iterator = iChunk.getRawElementIterator();
            while (iterator.hasNext()) {
                RawModelElement rawModelElement = (RawModelElement)iterator.next();
                Shape shape = rawModelElement.getShape();
                if (shape == null) continue;
                shape.getRect(rectangle2);
                if (rectangle2.height == 0) {
                    if (rectangle.y > rectangle2.y || rectangle.y + rectangle.height <= rectangle2.y) continue;
                    shape.draw(graphics2D);
                    continue;
                }
                if (!rectangle2.intersects(rectangle)) continue;
                shape.draw(graphics2D);
            }
        }
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void getRect(Rectangle rectangle) {
        IChunk iChunk = this.chunk();
        IChunkPanel iChunkPanel = iChunk.getChunkPanel();
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle.width = iChunkPanel.getChunkWidth();
        rectangle.height = iChunk.getHeight();
    }

    @Override
    public int getHandleCount() {
        return 0;
    }

    @Override
    public Handle getHandle(int n) {
        return null;
    }

    @Override
    protected void getHandlePos(int n, Point point) {
    }

    @Override
    protected void setHandlePos(int n, Point point) {
    }

    @Override
    protected int[] getHRulers() {
        return this.chunk().getChunkPanel().getHRulers();
    }

    @Override
    protected int[] getVRulers() {
        return this.chunk().getChunkPanel().getVRulers();
    }

    protected RawReport getReport() {
        return (RawReport)this.m_Model.getResourceProvider();
    }

    protected IChunk chunk() {
        return (IChunk)this.m_Model;
    }
}

