/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CubeHeader;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import javax.swing.Icon;

public class CubeHeaderShape
extends UiModelElementShape {
    private Rectangle m_Rectangle = new Rectangle(0, 0, 1000, 400);
    private Icon ROW_ICON = ERDIcons.CUBE_ROW_HEADER;
    private Icon COLUMN_ICON = ERDIcons.CUBE_COLUMN_HEADER;

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public String getName() {
        String string = this.getModel().getTagName();
        if ("cube-row".equals(string)) {
            return I18N.ERD.getString("Shape.CubeRowHeader");
        }
        if ("cube-column".equals(string)) {
            return I18N.ERD.getString("Shape.CubeColumnHeader");
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        String string = this.getModel().getTagName();
        if ("cube-row".equals(string)) {
            return this.ROW_ICON;
        }
        if ("cube-column".equals(string)) {
            return this.COLUMN_ICON;
        }
        return null;
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public void sizeToFitChildren() {
    }

    @Override
    public Rectangle getRect() {
        return this.m_Rectangle;
    }

    @Override
    public void getRect(Rectangle rectangle) {
        rectangle.x = this.m_Rectangle.x;
        rectangle.y = this.m_Rectangle.y;
        rectangle.width = this.m_Rectangle.width;
        rectangle.height = this.m_Rectangle.height;
    }

    @Override
    public void setRect(Rectangle rectangle) {
        this.m_Rectangle = rectangle;
    }

    public void layout(Graphics2D graphics2D) {
        CubeHeader cubeHeader = (CubeHeader)this.m_Model;
        String string = cubeHeader.getTitle();
        int n = 0;
        if (cubeHeader.isFontBold()) {
            n |= 1;
        }
        if (cubeHeader.isFontItalic()) {
            n |= 2;
        }
        Font font = new Font(cubeHeader.getFontName(), n, cubeHeader.getFontSize() / 20);
        font = font.deriveFont((float)cubeHeader.getFontSize() / 20.0f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        this.m_Rectangle.width = fontMetrics.stringWidth(string) * 20 + cubeHeader.getLeftMargin() + cubeHeader.getRightMargin() + 80;
        this.m_Rectangle.height = fontMetrics.getHeight() * 20 + cubeHeader.getTopMargin() + cubeHeader.getBottomMargin();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        CubeHeader cubeHeader = (CubeHeader)this.m_Model;
        GradientPaint gradientPaint = null;
        Rectangle rectangle = this.getRect();
        String string = cubeHeader.getBackgroundTopLeft();
        String string2 = cubeHeader.getBackgroundBottomRight();
        Color color = null;
        Color color2 = null;
        if (StringUtil.notEmpty(string)) {
            color = StandardColor.lookup(string);
        }
        if (StringUtil.notEmpty(string2)) {
            color2 = StandardColor.lookup(string2);
        }
        if (color != null || color2 != null) {
            if (color == null) {
                color = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 0);
            } else if (color2 == null) {
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
            }
            gradientPaint = new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x + rectangle.width, rectangle.y + rectangle.height, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle);
        }
        GRectangle gRectangle = this.getGRectangle(cubeHeader);
        gRectangle.draw(graphics2D);
        String string3 = cubeHeader.getTitle();
        if (StringUtil.notEmpty(string3)) {
            rectangle = gRectangle.getChildRect();
            int n = 0;
            if (cubeHeader.isFontBold()) {
                n |= 1;
            }
            if (cubeHeader.isFontItalic()) {
                n |= 2;
            }
            Font font = new Font(cubeHeader.getFontName(), n, cubeHeader.getFontSize() / 20);
            font = font.deriveFont((float)cubeHeader.getFontSize() / 20.0f);
            AttributedString attributedString = new AttributedString(string3);
            attributedString.addAttribute(TextAttribute.FONT, font);
            if (cubeHeader.isFontUnderline()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (cubeHeader.isFontStrikethrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            attributedString.addAttribute(TextAttribute.FOREGROUND, StandardColor.lookup(cubeHeader.getFontColor()));
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            float f = (float)textLayout.getBounds().getWidth();
            String string4 = cubeHeader.getTextAlign();
            float f2 = (float)rectangle.x / 20.0f;
            if ("Right".equals(string4)) {
                f2 = f2 + (float)rectangle.width / 20.0f - f;
            } else if ("Center".equals(string4)) {
                f2 += ((float)(rectangle.width / 20) - f) / 2.0f;
            }
            float f3 = (float)rectangle.y / 20.0f + (float)rectangle.height / 20.0f - ((float)(rectangle.height / 20) - textLayout.getAscent()) / 2.0f;
            graphics2D.scale(20.0, 20.0);
            textLayout.draw(graphics2D, f2, f3);
            graphics2D.scale(0.05, 0.05);
        }
    }

    @Override
    public boolean isHandleLocked(int n) {
        boolean bl = super.isHandleLocked(n);
        if (!bl) {
            return n < 5;
        }
        return bl;
    }

    protected GRectangle getGRectangle(CubeHeader cubeHeader) {
        GRectangle gRectangle = new GRectangle(this.m_Rectangle);
        gRectangle.setPadding(cubeHeader.getPaddingLeft(), cubeHeader.getPaddingTop(), cubeHeader.getPaddingRight(), cubeHeader.getPaddingBottom());
        BorderStyle borderStyle = BorderStyle.get(cubeHeader.getBorderStyle());
        if (borderStyle != BorderStyle.NONE) {
            Color color = StandardColor.lookup(cubeHeader.getBorderColor());
            int n = cubeHeader.getBorderWidth();
            int n2 = this.getSides(cubeHeader);
            gRectangle.setBorder(borderStyle, n, color, n2);
        }
        return gRectangle;
    }

    protected int getSides(CubeHeader cubeHeader) {
        int n = 0;
        if (cubeHeader.isBorderLeft()) {
            n |= 1;
        }
        if (cubeHeader.isBorderTop()) {
            n |= 2;
        }
        if (cubeHeader.isBorderRight()) {
            n |= 4;
        }
        if (cubeHeader.isBorderBottom()) {
            n |= 8;
        }
        return n;
    }
}

