/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.arch.Elixir;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import javax.swing.Icon;

public class CubeMeasureShape
extends UiModelElementShape {
    private Rectangle m_Rectangle = new Rectangle(0, 0, 1200, 400);
    private Icon MEASURE_ICON = ERDIcons.CUBE_MEASURE;

    public CubeMeasureShape() {
    }

    public CubeMeasureShape(CubeMeasure cubeMeasure) {
        this.setModel((RawModelElement)cubeMeasure);
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public String getName() {
        CubeMeasure cubeMeasure = (CubeMeasure)this.m_Model;
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        Function function = iFunctionFactory.getFunction(CubeHelper.CUBE_DATA_TYPE, cubeMeasure.getFunction());
        return function.getResultName(cubeMeasure.getName());
    }

    @Override
    public Icon getIcon() {
        return this.MEASURE_ICON;
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public void sizeToFitChildren() {
    }

    @Override
    public Rectangle getRect() {
        return this.m_Rectangle;
    }

    @Override
    public void getRect(Rectangle rectangle) {
        rectangle.x = this.m_Rectangle.x;
        rectangle.y = this.m_Rectangle.y;
        rectangle.width = this.m_Rectangle.width;
        rectangle.height = this.m_Rectangle.height;
    }

    @Override
    public void setRect(Rectangle rectangle) {
        this.m_Rectangle = rectangle;
    }

    public void layout(Graphics2D graphics2D) {
        CubeMeasure cubeMeasure = (CubeMeasure)this.m_Model;
        int n = 0;
        if (cubeMeasure.isFontBold()) {
            n |= 1;
        }
        if (cubeMeasure.isFontItalic()) {
            n |= 2;
        }
        Font font = new Font(cubeMeasure.getFontName(), n, cubeMeasure.getFontSize() / 20);
        font = font.deriveFont((float)cubeMeasure.getFontSize() / 20.0f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        this.m_Rectangle.width = fontMetrics.stringWidth(this.getName()) * 20 + cubeMeasure.getLeftMargin() + cubeMeasure.getRightMargin();
        this.m_Rectangle.height = fontMetrics.getHeight() * 20 + cubeMeasure.getTopMargin() + cubeMeasure.getBottomMargin();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        CubeMeasure cubeMeasure = (CubeMeasure)this.m_Model;
        super.draw(graphics2D);
        GRectangle gRectangle = this.getGRectangle(cubeMeasure);
        gRectangle.draw(graphics2D);
        int n = 0;
        if (cubeMeasure.isFontBold()) {
            n |= 1;
        }
        if (cubeMeasure.isFontItalic()) {
            n |= 2;
        }
        Font font = new Font(cubeMeasure.getFontName(), n, cubeMeasure.getFontSize() / 20);
        font = font.deriveFont((float)cubeMeasure.getFontSize() / 20.0f);
        AttributedString attributedString = new AttributedString(this.getName());
        attributedString.addAttribute(TextAttribute.FONT, font);
        if (cubeMeasure.isFontUnderline()) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (cubeMeasure.isFontStrikethrough()) {
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        attributedString.addAttribute(TextAttribute.FOREGROUND, StandardColor.lookup(cubeMeasure.getFontColor()));
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        float f = (float)textLayout.getBounds().getWidth();
        String string = cubeMeasure.getTextAlignment();
        Rectangle rectangle = gRectangle.getChildRect();
        float f2 = (float)rectangle.x / 20.0f;
        if ("Right".equals(string)) {
            f2 = f2 + (float)rectangle.width / 20.0f - f;
        } else if ("Center".equals(string)) {
            f2 += ((float)(rectangle.width / 20) - f) / 2.0f;
        }
        float f3 = (float)rectangle.y / 20.0f + (float)rectangle.height / 20.0f - ((float)(rectangle.height / 20) - textLayout.getAscent()) / 2.0f;
        graphics2D.scale(20.0, 20.0);
        textLayout.draw(graphics2D, f2, f3);
        graphics2D.scale(0.05, 0.05);
    }

    @Override
    public boolean isHandleLocked(int n) {
        boolean bl = super.isHandleLocked(n);
        if (!bl) {
            return n < 5;
        }
        return bl;
    }

    protected GRectangle getGRectangle(CubeMeasure cubeMeasure) {
        GRectangle gRectangle = new GRectangle(this.m_Rectangle);
        gRectangle.setPadding(cubeMeasure.getPaddingLeft(), cubeMeasure.getPaddingTop(), cubeMeasure.getPaddingRight(), cubeMeasure.getPaddingBottom());
        gRectangle.setBackground(StandardColor.lookup(cubeMeasure.getBackgroundColor()));
        BorderStyle borderStyle = BorderStyle.get(cubeMeasure.getBorderStyle());
        if (borderStyle != BorderStyle.NONE) {
            Color color = StandardColor.lookup(cubeMeasure.getBorderColor());
            int n = cubeMeasure.getBorderWidth();
            int n2 = this.getSides(cubeMeasure);
            gRectangle.setBorder(borderStyle, n, color, n2);
        }
        return gRectangle;
    }

    protected Rectangle getRect(CubeMeasure cubeMeasure) {
        return new Rectangle(cubeMeasure.getLeft(), cubeMeasure.getTop(), cubeMeasure.getWidth(), cubeMeasure.getHeight());
    }

    protected int getSides(CubeMeasure cubeMeasure) {
        int n = 0;
        if (cubeMeasure.isBorderLeft()) {
            n |= 1;
        }
        if (cubeMeasure.isBorderTop()) {
            n |= 2;
        }
        if (cubeMeasure.isBorderRight()) {
            n |= 4;
        }
        if (cubeMeasure.isBorderBottom()) {
            n |= 8;
        }
        return n;
    }
}

