/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.CubeHeaderShape;
import com.elixirtech.erd.reportdesigner.shape.CubeMeasureShape;
import com.elixirtech.erd.reportdesigner.shape.UiElementShape;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.CubeTable;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;

public class CubeTableShape
extends UiElementShape {
    @Override
    public String getName() {
        if (this.m_Model != null) {
            String string = ((CubeTable)this.m_Model).getName();
            return string;
        }
        return null;
    }

    public void layoutChildren(Graphics2D graphics2D) {
        CubeTable cubeTable = (CubeTable)this.m_Model;
        Rectangle rectangle = this.getRect();
        int n = cubeTable.getBorderWidth();
        if ("None".equals(cubeTable.getBorderStyle())) {
            n = 0;
        }
        int n2 = (cubeTable.isBorderLeft() ? n : 0) + cubeTable.getPaddingLeft();
        int n3 = (cubeTable.isBorderTop() ? n : 0) + cubeTable.getPaddingTop();
        int n4 = rectangle.x + n2;
        int n5 = rectangle.y + n3;
        CubeHeaderShape cubeHeaderShape = this.getRowShape();
        cubeHeaderShape.layout(graphics2D);
        CubeHeaderShape cubeHeaderShape2 = this.getColumnShape();
        cubeHeaderShape2.layout(graphics2D);
        Rectangle rectangle2 = cubeHeaderShape.getRect();
        Rectangle rectangle3 = cubeHeaderShape2.getRect();
        cubeHeaderShape.setRect(new Rectangle(n4, n5 + rectangle3.height, rectangle2.width, rectangle2.height));
        cubeHeaderShape2.setRect(new Rectangle(n4 + rectangle2.width, n5, rectangle3.width, rectangle3.height));
        int n6 = n2 + rectangle2.width + rectangle3.width;
        int n7 = n3 + rectangle2.height + rectangle3.height;
        CubeMeasureShape[] cubeMeasureShapeArray = this.getMeasureShapes();
        n4 += rectangle2.width;
        n5 += rectangle3.height;
        for (int i = 0; i < cubeMeasureShapeArray.length; ++i) {
            cubeMeasureShapeArray[i].layout(graphics2D);
            Rectangle rectangle4 = cubeMeasureShapeArray[i].getRect();
            rectangle4.x = n4;
            rectangle4.y = n5;
            cubeMeasureShapeArray[i].setRect(rectangle4);
            n6 = Math.max(n6, (n4 += rectangle4.width) - rectangle.x);
            n7 = Math.max(n7, n3 + rectangle3.height + rectangle4.height);
        }
        n7 += cubeTable.getPaddingBottom() + (cubeTable.isBorderBottom() ? n : 0);
        if (rectangle.width < (n6 += cubeTable.getPaddingRight() + (cubeTable.isBorderRight() ? n : 0))) {
            rectangle.width = n6;
        }
        if (rectangle.height < n7) {
            rectangle.height = n7;
        }
        this.setRect(rectangle);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.layoutChildren(graphics2D);
        super.draw(graphics2D);
        this.getRowShape().draw(graphics2D);
        this.getColumnShape().draw(graphics2D);
        CubeMeasureShape[] cubeMeasureShapeArray = this.getMeasureShapes();
        for (int i = 0; i < cubeMeasureShapeArray.length; ++i) {
            cubeMeasureShapeArray[i].draw(graphics2D);
        }
    }

    @Override
    public Icon getIcon() {
        return ERDIcons.CUBE;
    }

    protected CubeHeaderShape getRowShape() {
        return (CubeHeaderShape)((CubeTable)this.m_Model).getRow().getShape();
    }

    protected CubeHeaderShape getColumnShape() {
        return (CubeHeaderShape)((CubeTable)this.m_Model).getColumn().getShape();
    }

    protected CubeMeasureShape[] getMeasureShapes() {
        CubeTable cubeTable = (CubeTable)this.m_Model;
        int n = cubeTable.getMeasureCount();
        CubeMeasureShape[] cubeMeasureShapeArray = new CubeMeasureShape[n];
        for (int i = 0; i < n; ++i) {
            CubeMeasure cubeMeasure = cubeTable.getMeasure(i);
            cubeMeasureShapeArray[i] = (CubeMeasureShape)cubeMeasure.getShape();
        }
        return cubeMeasureShapeArray;
    }
}

