/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.ShapeGroup;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.Icon;

public class GroupShape
extends UiModelElementShape {
    private static Icon m_GroupIcon = ERDIcons.GROUP;

    @Override
    public String getName() {
        return "Group";
    }

    @Override
    public void setModel(RawModelElement rawModelElement) {
        super.setModel(rawModelElement);
        this.buildBoundingBox();
    }

    @Override
    public Icon getIcon() {
        return m_GroupIcon;
    }

    public int getChildCount() {
        return ((ShapeGroup)this.m_Model).getRawElementCount();
    }

    public AbstractShape getChild(int n) {
        return (AbstractShape)((ShapeGroup)this.m_Model).getRawElement(n).getShape();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = this.getBoundingBox();
        if (rectangle != null) {
            if (this.m_Model.getLeft() > rectangle.x) {
                this.m_Model.setLeft(rectangle.x);
            }
            if (this.m_Model.getTop() > rectangle.y) {
                this.m_Model.setTop(rectangle.y);
            }
            int n = rectangle.x + rectangle.width;
            int n2 = rectangle.y + rectangle.height;
            int n3 = this.m_Model.getLeft() + this.m_Model.getWidth();
            int n4 = this.m_Model.getTop() + this.m_Model.getHeight();
            if (n3 < n) {
                this.m_Model.setWidth(n - this.m_Model.getLeft());
            }
            if (n4 < n2) {
                this.m_Model.setHeight(n2 - this.m_Model.getTop());
            }
        }
        super.draw(graphics2D);
        Iterator iterator = ((ShapeGroup)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            ((AbstractShape)rawModelElement.getShape()).draw(graphics2D);
        }
    }

    public Rectangle getBoundingBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        Iterator iterator = ((ShapeGroup)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (abstractShape != null) {
                Rectangle rectangle = abstractShape.getRect();
                n = Math.min(n, rectangle.x);
                n2 = Math.min(n2, rectangle.y);
                n3 = Math.max(n3, rectangle.x + rectangle.width);
                n4 = Math.max(n4, rectangle.y + rectangle.height);
                continue;
            }
            return null;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public void buildBoundingBox() {
        Rectangle rectangle = this.getBoundingBox();
        if (rectangle != null) {
            super.setRect(rectangle);
        }
    }

    protected void shiftChildren(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        Iterator iterator = ((ShapeGroup)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (abstractShape == null) continue;
            abstractShape.getRect(rectangle);
            rectangle.x += n;
            rectangle.y += n2;
            abstractShape.setRect(rectangle);
        }
    }

    @Override
    public void setRect(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        this.getRect(rectangle2);
        if (rectangle2.width != rectangle.width || rectangle2.height != rectangle.height) {
            int n = rectangle.x + rectangle.width;
            int n2 = rectangle.y + rectangle.height;
            Iterator iterator = ((ShapeGroup)this.m_Model).getRawElementIterator();
            while (iterator.hasNext()) {
                RawModelElement rawModelElement = (RawModelElement)iterator.next();
                AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
                Rectangle rectangle3 = abstractShape.getRect();
                if (rectangle.x > rectangle3.x) {
                    rectangle.x = rectangle3.x;
                }
                if (rectangle.y > rectangle3.y) {
                    rectangle.y = rectangle3.y;
                }
                if (n < rectangle3.x + rectangle3.width) {
                    n = rectangle3.x + rectangle3.width;
                }
                if (n2 >= rectangle3.y + rectangle3.height) continue;
                n2 = rectangle3.y + rectangle3.height;
            }
            rectangle.width = n - rectangle.x;
            rectangle.height = n2 - rectangle.y;
        } else {
            this.shiftChildren(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        }
        super.setRect(rectangle);
    }
}

