/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.BoxShape;
import com.elixirtech.erd.reportdesigner.shape.CellShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.util.StringUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class HBoxShape
extends BoxShape {
    private static final int HANDLE_START = 100;
    private static final int Y_OFFSET = 160;
    protected HBox m_HBoxModel;
    private static Icon m_Icon = ERDIcons.HORIZONTAL_BOX;

    @Override
    public void setModel(RawModelElement rawModelElement) {
        this.m_HBoxModel = (HBox)rawModelElement;
        super.setModel(rawModelElement);
    }

    @Override
    public String getName() {
        String string = this.m_HBoxModel.getName();
        if (StringUtil.notEmpty(string)) {
            return string;
        }
        return I18N.ERD.getString("Shape.HorizontalBox");
    }

    @Override
    public Icon getIcon() {
        return m_Icon;
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public void sizeToFitChildren() {
    }

    @Override
    public void setRect(Rectangle rectangle) {
        super.setRect(rectangle);
        this.layoutCells();
    }

    @Override
    public void layoutCells() {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        int n = rectangle.x;
        Rectangle rectangle2 = new Rectangle();
        long l = this.getTotalWeight();
        Iterator iterator = this.m_HBoxModel.getCellIterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            long l2 = cell.getWeight();
            CellShape cellShape = (CellShape)cell.getShape();
            rectangle2.x = n;
            rectangle2.y = rectangle.y;
            rectangle2.width = l == 0L ? 0 : (int)(l2 * (long)rectangle.width / l);
            l -= l2;
            rectangle.width -= rectangle2.width;
            rectangle2.height = rectangle.height;
            cellShape.setRect(rectangle2);
            n += rectangle2.width;
        }
        this.buildHandles();
    }

    @Override
    protected void buildHandles(List<Handle> list) {
        int n = this.m_HBoxModel.getCellCount();
        for (int i = n - 2; i >= 0; --i) {
            list.add(new SizeHandle(this, 100 + i, Cursor.getPredefinedCursor(12)));
        }
        super.buildHandles(list);
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        if (n >= 100) {
            int n2 = n - 100;
            Cell cell = this.m_HBoxModel.getCell(n2);
            CellShape cellShape = (CellShape)cell.getShape();
            Rectangle rectangle = new Rectangle();
            ((AbstractShape)cellShape).getRect(rectangle);
            point.x = rectangle.x + rectangle.width;
            point.y = rectangle.y + 160;
        } else {
            super.getHandlePos(n, point);
        }
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        if (n >= 100) {
            Iterator iterator;
            int[] nArray = this.getHRulers();
            this.snapToRulers(point, nArray, null, true);
            int n2 = n - 100;
            Cell cell = this.m_HBoxModel.getCell(n2);
            Rectangle rectangle = new Rectangle();
            this.getRect(rectangle);
            while (this.getTotalWeight() < (long)rectangle.width) {
                iterator = this.m_HBoxModel.getCellIterator();
                while (iterator.hasNext()) {
                    Cell cell2 = (Cell)iterator.next();
                    cell2.setWeight(Math.max(1, cell2.getWeight() * 10));
                }
            }
            iterator = this.m_HBoxModel.getCell(n2 + 1);
            int n3 = cell.getLeft();
            int n4 = n3 + 80;
            int n5 = iterator.getLeft() + iterator.getWidth() - 80;
            point.x = Math.max(point.x, n4);
            point.x = Math.min(point.x, n5);
            int n6 = Math.max(80, point.x - n3);
            int n7 = cell.getWeight() + iterator.getWeight();
            int n8 = cell.getWidth() + iterator.getWidth();
            int n9 = n7 * n6 / n8;
            int n10 = Math.abs(cell.getWeight() - n9);
            if (n10 > 20000) {
                System.out.println("Something wrong here");
            }
            cell.setWeight(n9);
            iterator.setWeight(n7 - n9);
            this.layoutCells();
        } else {
            super.setHandlePos(n, point);
        }
    }
}

